/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.text.ParseException;
import java.time.LocalDate;
import java.util.Date;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.components.kmelia.service.KmeliaDeleter;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.ComponentInstManager;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class KmeliaBinsScheduledPurger
implements Initialization {
    private static final String COMPONENT_NAME = "kmelia";
    private static final String SETTINGS_NAME = "org.silverpeas.kmelia.settings.kmeliaSettings";
    private static final String JOB_NAME = "BinOlderItemsDeleter";
    @Inject
    private KmeliaDeleter deleter;
    @Inject
    private ComponentInstManager componentInstManager;
    @Inject
    private NodeService nodeService;
    @Inject
    private PublicationService publicationService;

    public void init() throws SchedulerException {
        String cron = this.getSchedulingCron();
        if (!cron.isEmpty()) {
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(JOB_NAME);
            scheduler.scheduleJob((Job)new BinOlderItemsDeleter(), KmeliaBinsScheduledPurger.eachTimeAt(cron));
        }
        new BinOlderItemsDeleter().execute(JobExecutionContext.createWith((String)JOB_NAME, (Date)new Date()));
    }

    @NonNull
    private static JobTrigger eachTimeAt(String cron) throws SchedulerException {
        try {
            return JobTrigger.triggerAt((String)cron);
        }
        catch (ParseException e) {
            throw new SchedulerException(e.getMessage(), (Throwable)e);
        }
    }

    public void release() throws SchedulerException {
        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
        if (scheduler.isJobScheduled(JOB_NAME)) {
            scheduler.unscheduleJob(JOB_NAME);
        }
    }

    private String getSchedulingCron() {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)SETTINGS_NAME);
        return settings.getString("kmelia.autoDeletionCron", "");
    }

    private class BinOlderItemsDeleter
    extends Job {
        BinOlderItemsDeleter() {
            super(KmeliaBinsScheduledPurger.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            int delay = this.getDeletionDelay();
            if (delay > 0) {
                SilverLogger.getLogger((Object)((Object)this)).info("Purge Kmelia bins from contributions removed more than " + delay + " days", new Object[0]);
                try {
                    Transaction.performInOne(() -> {
                        LocalDate now = LocalDate.now();
                        WAComponent.getByName((String)KmeliaBinsScheduledPurger.COMPONENT_NAME).ifPresent(component -> this.getAllInstanceIds((WAComponent)component).map(id -> KmeliaBinsScheduledPurger.COMPONENT_NAME + id).forEach(instanceId -> {
                            NodePK bin = new NodePK("1", instanceId);
                            KmeliaBinsScheduledPurger.this.nodeService.getChildrenDetails(bin).stream().filter(node -> this.isOlder((NodeDetail)node, now)).forEach(topic -> KmeliaBinsScheduledPurger.this.deleter.deleteTopic(topic.getNodePK()));
                            KmeliaBinsScheduledPurger.this.publicationService.getDetailsByFatherPK(bin).stream().filter(publication -> this.isOlder((PublicationDetail)publication, now)).forEach(publication -> KmeliaBinsScheduledPurger.this.deleter.deletePublication(publication.getPK()));
                        }));
                        return null;
                    });
                }
                catch (SilverpeasRuntimeException e) {
                    SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
                }
            }
        }

        private int getDeletionDelay() {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)KmeliaBinsScheduledPurger.SETTINGS_NAME);
            int delay = settings.getInteger("kmelia.autoDeletionDelay", 0);
            return Math.max(delay, 0);
        }

        private boolean isOlder(PublicationDetail publication, LocalDate date) {
            if (!publication.isRemoved()) {
                return true;
            }
            return this.isOlder(publication.getRemovalDate(), date);
        }

        private boolean isOlder(NodeDetail topic, LocalDate date) {
            if (!topic.isRemoved()) {
                return true;
            }
            return this.isOlder(topic.getRemovalDate(), date);
        }

        private boolean isOlder(Date removalDate, LocalDate date) {
            LocalDate removeDayDateWithDelay = DateUtil.toLocalDate((Date)removalDate).plusDays(this.getDeletionDelay());
            return removeDayDateWithDelay.isBefore(date) || removeDayDateWithDelay.isEqual(date);
        }

        private Stream<String> getAllInstanceIds(WAComponent component) {
            try {
                return Stream.of(KmeliaBinsScheduledPurger.this.componentInstManager.getAllCompoIdsByComponentName(component.getName()));
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
    }
}

