/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.variables;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.variables.Variable;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.variables.VariableScheduledValueRepository;

public class VariableValueSet
implements Collection<VariableScheduledValue> {
    final Variable variable;

    VariableValueSet(Variable variable) {
        this.variable = variable;
    }

    @Override
    public boolean add(VariableScheduledValue value) {
        value.setVariable(this.variable);
        return this.variable.values().add(value);
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends VariableScheduledValue> values) {
        return this.variable.values().addAll(values.stream().map(v -> {
            v.setVariable(this.variable);
            return v;
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.variable.values().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.variable.values().retainAll(c);
    }

    @Override
    public void clear() {
        this.variable.values().clear();
    }

    public VariableScheduledValue addAndSave(VariableScheduledValue value) {
        return Transaction.performInOne(() -> {
            value.setVariable(this.variable);
            return VariableScheduledValueRepository.get().save(value);
        });
    }

    @Override
    public Stream<VariableScheduledValue> stream() {
        return this.variable.values().stream();
    }

    public Optional<VariableScheduledValue> get(String id) {
        return this.variable.values().stream().filter(v -> v.getId().equals(id)).findFirst();
    }

    public boolean remove(String id) {
        return this.variable.values().removeIf(v -> v.getId().equals(id));
    }

    public Optional<VariableScheduledValue> getCurrent() {
        LocalDate today = LocalDate.now();
        return this.variable.values().stream().filter(v -> v.getPeriod().includes(today)).findFirst();
    }

    public Optional<VariableScheduledValue> getNext() {
        LocalDate today = LocalDate.now();
        return this.variable.values().stream().filter(v -> v.getPeriod().startsAfter(today)).findFirst();
    }

    public Optional<VariableScheduledValue> getPrevious() {
        LocalDate today = LocalDate.now();
        return this.variable.values().stream().filter(v -> v.getPeriod().endsBefore(today)).findFirst();
    }

    @Override
    public int size() {
        return this.variable.values().size();
    }

    @Override
    public boolean isEmpty() {
        return this.variable.values().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.variable.values().contains(o);
    }

    @Override
    public Iterator<VariableScheduledValue> iterator() {
        return this.variable.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.variable.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.variable.values().toArray(a);
    }

    @Override
    public void forEach(Consumer<? super VariableScheduledValue> action) {
        this.variable.values().forEach(action);
    }

    @Override
    public Spliterator<VariableScheduledValue> spliterator() {
        return this.variable.values().spliterator();
    }
}

