/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.UnaryOperator;
import org.silverpeas.core.exception.DecodingException;
import org.silverpeas.core.exception.EncodingException;

public class JSONCodec {
    private JSONCodec() {
    }

    public static <T> String encode(T bean) {
        ObjectMapper mapper = JSONCodec.getObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, bean);
        }
        catch (IOException ex) {
            throw new EncodingException(ex.getMessage(), ex);
        }
        return writer.toString();
    }

    public static String encodeObject(UnaryOperator<JSONObject> beanBuilder) {
        ObjectMapper mapper = JSONCodec.getObjectMapper();
        StringWriter writer = new StringWriter();
        ObjectNode node = mapper.createObjectNode();
        JSONObject bean = (JSONObject)beanBuilder.apply(new JSONObject(node));
        try {
            mapper.writeValue((Writer)writer, (Object)bean.getObjectNode());
        }
        catch (IOException ex) {
            throw new EncodingException(ex.getMessage(), ex);
        }
        return writer.toString();
    }

    public static String encodeArray(UnaryOperator<JSONArray> arrayBuilder) {
        ObjectMapper mapper = JSONCodec.getObjectMapper();
        StringWriter writer = new StringWriter();
        ArrayNode node = mapper.createArrayNode();
        JSONArray array = (JSONArray)arrayBuilder.apply(new JSONArray(node));
        try {
            mapper.writeValue((Writer)writer, (Object)array.getArrayNode());
        }
        catch (IOException ex) {
            throw new EncodingException(ex.getMessage(), ex);
        }
        return writer.toString();
    }

    public static <T> T decode(String json, Class<T> beanType) {
        Object bean;
        ObjectMapper mapper = JSONCodec.getObjectMapper();
        try {
            bean = mapper.readValue(json, beanType);
        }
        catch (IOException ex) {
            throw new DecodingException(ex.getMessage(), ex);
        }
        return (T)bean;
    }

    public static <T> T decode(InputStream jsonStream, Class<T> beanType) {
        Object bean;
        ObjectMapper mapper = JSONCodec.getObjectMapper();
        try {
            bean = mapper.readValue(jsonStream, beanType);
        }
        catch (IOException ex) {
            throw new DecodingException(ex.getMessage(), ex);
        }
        return (T)bean;
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static class JSONArray {
        private final ArrayNode arrayNode;

        protected JSONArray(ArrayNode arrayNode) {
            this.arrayNode = arrayNode;
        }

        protected ArrayNode getArrayNode() {
            return this.arrayNode;
        }

        public JSONArray add(Number v) {
            if (v instanceof Short) {
                this.add((Short)v);
            } else if (v instanceof Integer) {
                this.add((Integer)v);
            } else if (v instanceof Long) {
                this.add((Long)v);
            } else if (v instanceof Float) {
                this.add((Float)v);
            } else if (v instanceof Double) {
                this.add((Double)v);
            } else if (v instanceof BigDecimal) {
                this.add((BigDecimal)v);
            } else {
                this.add(JSONCodec.encode(v));
            }
            return this;
        }

        public JSONArray add(Short v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(Integer v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(Long v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(Float v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(Double v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(BigDecimal v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(String v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(Boolean v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray add(byte[] v) {
            this.arrayNode.add(v);
            return this;
        }

        public JSONArray addJSONObject(UnaryOperator<JSONObject> beanBuilder) {
            ObjectNode node = this.arrayNode.addObject();
            beanBuilder.apply(new JSONObject(node));
            return this;
        }

        public JSONArray addJSONArray(UnaryOperator<JSONArray> arrayBuilder) {
            ArrayNode node = this.arrayNode.addArray();
            arrayBuilder.apply(new JSONArray(node));
            return this;
        }

        public JSONArray addJSONArray(List<String> elements) {
            for (String element : elements) {
                this.arrayNode.add(element);
            }
            return this;
        }
    }

    public static class JSONObject {
        private final ObjectNode objectNode;

        protected JSONObject(ObjectNode objectNode) {
            this.objectNode = objectNode;
        }

        protected ObjectNode getObjectNode() {
            return this.objectNode;
        }

        public JSONObject putNull(String fieldName) {
            this.objectNode.putNull(fieldName);
            return this;
        }

        public JSONObject put(String fieldName, Number v) {
            if (v instanceof Short) {
                this.put(fieldName, (Short)v);
            } else if (v instanceof Integer) {
                this.put(fieldName, (Integer)v);
            } else if (v instanceof Long) {
                this.put(fieldName, (Long)v);
            } else if (v instanceof Float) {
                this.put(fieldName, (Float)v);
            } else if (v instanceof Double) {
                this.put(fieldName, (Double)v);
            } else if (v instanceof BigDecimal) {
                this.put(fieldName, (BigDecimal)v);
            } else {
                this.put(fieldName, JSONCodec.encode(v));
            }
            return this;
        }

        public JSONObject put(String fieldName, Short v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, Integer v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, Long v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, Float v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, Double v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, BigDecimal v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, String v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, Boolean v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject put(String fieldName, byte[] v) {
            this.objectNode.put(fieldName, v);
            return this;
        }

        public JSONObject putJSONArray(String fieldName, UnaryOperator<JSONArray> arrayBuilder) {
            arrayBuilder.apply(new JSONArray(this.objectNode.putArray(fieldName)));
            return this;
        }

        public JSONObject putJSONObject(String fieldName, UnaryOperator<JSONObject> arrayBuilder) {
            arrayBuilder.apply(new JSONObject(this.objectNode.putObject(fieldName)));
            return this;
        }
    }
}

