/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class EmailAddress {
    private static final String EMAIL_PATTERN = "^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,4}$";
    private final String address;

    public EmailAddress(String addressEmail) {
        if (!EmailAddress.isValid(addressEmail)) {
            throw new IllegalArgumentException("The specified address isn't a valid email one: " + addressEmail);
        }
        this.address = addressEmail;
    }

    public InternetAddress asInternetAddress() {
        try {
            return new InternetAddress(this.address);
        }
        catch (AddressException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static boolean isValid(String address) {
        boolean isOk;
        if (address == null) {
            return false;
        }
        try {
            new InternetAddress(address);
            isOk = Pattern.matches(EMAIL_PATTERN, address);
        }
        catch (AddressException ex) {
            isOk = false;
        }
        return isOk;
    }

    public String toString() {
        return this.address;
    }
}

