/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.thread.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class ReentrantSemaphore {
    private final Semaphore semaphore;
    private final Map<Thread, Integer> lockers = new ConcurrentHashMap<Thread, Integer>();

    public ReentrantSemaphore(int permits) {
        this.semaphore = permits > 0 ? new Semaphore(permits, true) : null;
    }

    public void acquire() throws InterruptedException {
        if (this.semaphore != null) {
            Integer nb = this.lockers.get(Thread.currentThread());
            if (nb == null) {
                this.semaphore.acquire();
                nb = 0;
            }
            this.lockers.put(Thread.currentThread(), nb + 1);
        }
    }

    public void release() {
        Integer nb;
        if (this.semaphore != null && (nb = this.lockers.get(Thread.currentThread())) != null) {
            if (nb == 1) {
                this.semaphore.release();
                this.lockers.remove(Thread.currentThread());
            } else {
                this.lockers.put(Thread.currentThread(), nb - 1);
            }
        }
    }
}

