/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.selection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SelectionContext
implements Serializable {
    @XmlElement(required=true)
    private Reason reason = Reason.TRANSFER;
    @XmlElement
    private final Map<String, String> attributes = new HashMap<String, String>();

    protected SelectionContext() {
    }

    public SelectionContext(Reason reason) {
        this.reason = reason;
    }

    public void putAttribute(String attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public Reason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectionContext that = (SelectionContext)o;
        return this.reason == that.reason && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.attributes});
    }

    public static enum Reason {
        TRANSFER,
        COPY,
        MOVE;

    }
}

