/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.repository.jpa;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifierConverter;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.EntityManagerProvider;
import org.silverpeas.core.persistence.datasource.repository.EntityRepository;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.QueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.persistence.datasource.repository.jpa.NoNamedParameter;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.PaginationList;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractJpaEntityRepository<T extends AbstractJpaEntity<T, ?>>
implements EntityRepository<T> {
    private static final int DEFAULT_MAXIMUM_ITEMS_IN_CLAUSE = 500;
    private static final String FROM_CLAUSE = "from ";
    private int maximumItemsInClause = 500;
    private final EntityIdentifierConverter identifierConverter = new EntityIdentifierConverter(this.getEntityIdentifierClass());

    @Override
    public SilverpeasList<T> save(List<T> entities) {
        OperationContext.fromCurrentRequester();
        SilverpeasArrayList savedEntities = new SilverpeasArrayList(entities.size());
        for (AbstractJpaEntity entity : entities) {
            if (entity.isPersisted()) {
                savedEntities.add((AbstractJpaEntity)this.getEntityManager().merge((Object)entity));
                continue;
            }
            this.getEntityManager().persist((Object)entity);
            savedEntities.add(entity);
        }
        return savedEntities;
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    @Override
    public boolean contains(T entity) {
        return this.getEntityManager().contains(entity);
    }

    @Override
    public SilverpeasList<T> getAll() {
        List all = this.getEntityManager().createQuery("select a from " + this.getEntityClass().getSimpleName() + " a", this.getEntityClass()).getResultList();
        return SilverpeasList.wrap(all);
    }

    @Override
    public T getById(String id) {
        return this.getByIdentifier((EntityIdentifier)this.getIdentifierConverter().convertToEntityIdentifier(id));
    }

    @Override
    public SilverpeasList<T> getById(Collection<String> ids) {
        SilverpeasList<T> entities = this.getByIdentifiers(this.getIdentifierConverter().convertToEntityIdentifiers(ids));
        return SilverpeasList.wrap(entities);
    }

    @Override
    public void delete(List<T> entities) {
        entities.stream().filter(AbstractJpaEntity::isPersisted).forEach(e -> {
            IdentifiableEntity entity = this.getById(e.getId());
            this.getEntityManager().remove((Object)entity);
        });
    }

    @Override
    public long deleteById(Collection<String> ids) {
        return this.deleteByIdentifier(this.getIdentifierConverter().convertToEntityIdentifiers(ids));
    }

    protected long countByCriteria(QueryCriteria criteria) {
        String jpqlQuery = this.toJPQLQuery(criteria);
        NamedParameters parameters = (NamedParameters)criteria.clause().parameters();
        return this.countFromJpqlString(jpqlQuery, parameters);
    }

    @Override
    public SilverpeasList<T> findByCriteria(QueryCriteria criteria) {
        String jpqlQuery = this.toJPQLQuery(criteria);
        NamedParameters parameters = (NamedParameters)criteria.clause().parameters();
        return this.listFromJpqlString(jpqlQuery, parameters, criteria.pagination());
    }

    protected SilverpeasList<T> findByNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.listFromNamedQuery(namedQuery, parameters);
    }

    protected T findFirstByNamedQuery(String namedQuery, NamedParameters parameters) {
        return (T)((AbstractJpaEntity)this.first(this.listFromNamedQuery(namedQuery, parameters)));
    }

    protected NamedParameters newNamedParameters() {
        return new NamedParameters();
    }

    protected NoNamedParameter noParameter() {
        return new NoNamedParameter();
    }

    protected long countFromJpqlString(String query, NamedParameters parameters) {
        String countQuery = "select count(*) " + query.replaceFirst("(?i)select .*from ", FROM_CLAUSE).replaceFirst("(?i)order by.*", "");
        return this.getFromJpqlString(countQuery, parameters, Long.class);
    }

    protected T getFromJpqlString(String query, NamedParameters parameters) {
        return (T)((AbstractJpaEntity)this.getFromJpqlString(query, parameters, this.getEntityClass()));
    }

    protected <U> U getFromJpqlString(String query, NamedParameters parameters, Class<U> returnEntityType) {
        return this.getFromQuery(this.getEntityManager().createQuery(query, returnEntityType), parameters);
    }

    protected SilverpeasList<T> listFromJpqlString(String query, NamedParameters parameters) {
        return this.listFromJpqlString(query, parameters, this.getEntityClass());
    }

    protected SilverpeasList<T> listFromJpqlString(String query, NamedParameters parameters, PaginationCriterion pagination) {
        return this.listFromJpqlString(query, parameters, pagination, this.getEntityClass());
    }

    protected <U> SilverpeasList<U> listFromJpqlString(String query, NamedParameters parameters, Class<U> returnEntityType) {
        return this.listFromJpqlString(query, parameters, PaginationCriterion.NO_PAGINATION, returnEntityType);
    }

    protected <U> SilverpeasList<U> listFromJpqlString(String jpqlQuery, NamedParameters parameters, PaginationCriterion pagination, Class<U> returnEntityType) {
        TypedQuery query = this.getEntityManager().createQuery(jpqlQuery, returnEntityType);
        long count = this.applyPaginationOnQuery(jpqlQuery, query, parameters, pagination);
        SilverpeasList<U> listOfEntities = this.getAllFromQuery(query, parameters);
        return count >= 1L ? PaginationList.from(listOfEntities, count) : listOfEntities;
    }

    protected Stream<T> streamFromJpqlString(String query, NamedParameters parameters) {
        return this.streamFromJpqlString(query, parameters, this.getEntityClass());
    }

    protected <U> Stream<U> streamFromJpqlString(String query, NamedParameters parameters, Class<U> returnEntityType) {
        return this.streamAllFromQuery(this.getEntityManager().createQuery(query, returnEntityType), parameters);
    }

    protected long updateFromJpqlQuery(String query, NamedParameters parameters) {
        return this.updateFromQuery(this.getEntityManager().createQuery(query), parameters);
    }

    protected long deleteFromJpqlQuery(String query, NamedParameters parameters) {
        return this.deleteFromQuery(this.getEntityManager().createQuery(query), parameters);
    }

    protected T getFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return (T)((AbstractJpaEntity)this.getFromNamedQuery(namedQuery, parameters, this.getEntityClass()));
    }

    protected <U> U getFromNamedQuery(String namedQuery, NamedParameters parameters, Class<U> returnEntityType) {
        return this.getFromQuery(this.getEntityManager().createNamedQuery(namedQuery, returnEntityType), parameters);
    }

    protected SilverpeasList<T> listFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.listFromNamedQuery(namedQuery, parameters, this.getEntityClass());
    }

    protected <U> SilverpeasList<U> listFromNamedQuery(String namedQuery, NamedParameters parameters, Class<U> returnEntityType) {
        return this.getAllFromQuery(this.getEntityManager().createNamedQuery(namedQuery, returnEntityType), parameters);
    }

    protected Stream<T> streamByNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.streamByNamedQuery(namedQuery, parameters, this.getEntityClass());
    }

    protected <U> Stream<U> streamByNamedQuery(String namedQuery, NamedParameters parameters, Class<U> returnEntityType) {
        return this.streamAllFromQuery(this.getEntityManager().createNamedQuery(namedQuery, returnEntityType), parameters);
    }

    protected long updateFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.updateFromQuery(this.getEntityManager().createNamedQuery(namedQuery), parameters);
    }

    protected long deleteFromNamedQuery(String namedQuery, NamedParameters parameters) {
        return this.deleteFromQuery(this.getEntityManager().createNamedQuery(namedQuery), parameters);
    }

    protected int getMaximumItemsInClause() {
        return this.maximumItemsInClause;
    }

    protected void setMaximumItemsInClause(int maximumItemsInClause) {
        this.maximumItemsInClause = maximumItemsInClause;
    }

    protected EntityManager getEntityManager() {
        return EntityManagerProvider.get().getEntityManager();
    }

    protected EntityIdentifierConverter getIdentifierConverter() {
        return this.identifierConverter;
    }

    protected Class<T> getEntityClass() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return (Class)((ParameterizedType)this.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private T getByIdentifier(EntityIdentifier id) {
        return (T)((AbstractJpaEntity)this.getEntityManager().find(this.getEntityClass(), (Object)id));
    }

    private <U extends EntityIdentifier> SilverpeasList<T> getByIdentifiers(Collection<U> ids) {
        SilverpeasList entities = new SilverpeasArrayList(ids.size());
        String selectQuery = "select a from " + this.getEntityClass().getName() + " a where a.id in :ids";
        for (Collection<U> entityIds : this.split(new HashSet<U>(ids))) {
            List tmp = this.newNamedParameters().add("ids", entityIds).applyTo(this.getEntityManager().createQuery(selectQuery, this.getEntityClass())).getResultList();
            if (entities.isEmpty()) {
                entities = SilverpeasList.wrap(tmp);
                continue;
            }
            entities.addAll(tmp);
        }
        return entities;
    }

    private String toJPQLQuery(QueryCriteria criteria) {
        Object query = criteria.clause().text();
        String queryInLowerCase = ((String)query).toLowerCase();
        if (queryInLowerCase.startsWith("select")) {
            query = ((String)query).substring(queryInLowerCase.indexOf("from"));
        }
        if (!queryInLowerCase.startsWith(FROM_CLAUSE)) {
            query = FROM_CLAUSE + this.getEntityClass().getSimpleName() + " where " + (String)query;
        }
        return query;
    }

    private <U> SilverpeasList<U> getAllFromQuery(TypedQuery<U> query, NamedParameters parameters) {
        return SilverpeasList.wrap(parameters.applyTo(query).getResultList());
    }

    private <U> Stream<U> streamAllFromQuery(TypedQuery<U> query, NamedParameters parameters) {
        return parameters.applyTo(query).getResultList().stream();
    }

    private <U> U getFromQuery(TypedQuery<U> query, NamedParameters parameters) {
        try {
            return (U)parameters.applyTo(query).getSingleResult();
        }
        catch (NoResultException e) {
            SilverLogger.getLogger((Object)this).debug(e.getMessage(), new Object[]{e});
            return null;
        }
        catch (NonUniqueResultException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private <U extends EntityIdentifier> long deleteByIdentifier(Collection<U> ids) {
        long nbDeletes = 0L;
        Query deleteQuery = this.getEntityManager().createQuery("delete from " + this.getEntityClass().getName() + " a where a.id in :ids");
        for (Collection<U> entityIds : this.split(ids)) {
            nbDeletes += (long)this.newNamedParameters().add("ids", entityIds).applyTo(deleteQuery).executeUpdate();
        }
        return nbDeletes;
    }

    private long deleteFromQuery(Query deleteQuery, NamedParameters parameters) {
        return parameters.applyTo(deleteQuery).executeUpdate();
    }

    private long updateFromQuery(Query updateQuery, NamedParameters parameters) {
        return parameters.applyTo(updateQuery).executeUpdate();
    }

    protected <E> Collection<Collection<E>> split(Collection<E> collection) {
        return CollectionUtil.split(collection, this.getMaximumItemsInClause());
    }

    private <U> U first(SilverpeasList<U> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        return (U)entities.get(0);
    }

    private <U extends EntityIdentifier> Class<U> getEntityIdentifierClass() {
        return (Class)((ParameterizedType)this.getEntityClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }

    private <U> long applyPaginationOnQuery(String jpqlQuery, TypedQuery<U> query, NamedParameters parameters, PaginationCriterion pagination) {
        long count = 0L;
        if (pagination != null && pagination.isDefined()) {
            count = this.countFromJpqlString(jpqlQuery, parameters);
            query.setFirstResult((pagination.getPageNumber() - 1) * pagination.getItemCount());
            query.setMaxResults(pagination.getItemCount());
        }
        return count;
    }
}

