/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.identifier;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Embeddable
public class UniqueIntegerIdentifier
implements EntityIdentifier {
    private static final long serialVersionUID = 8570844400186460258L;
    @Column(name="id", nullable=false)
    private Integer id;

    public static UniqueIntegerIdentifier from(String value) {
        return new UniqueIntegerIdentifier().fromString(value);
    }

    public static UniqueIntegerIdentifier from(int value) {
        return new UniqueIntegerIdentifier().setId(value);
    }

    public Integer getId() {
        return this.id;
    }

    private UniqueIntegerIdentifier setId(Integer id) {
        this.id = id;
        return this;
    }

    @Override
    public String asString() {
        return this.getId().toString();
    }

    @Override
    public UniqueIntegerIdentifier fromString(String id) {
        return this.setId(Integer.valueOf(id));
    }

    @Override
    public UniqueIntegerIdentifier generateNewId(String ... parameters) {
        String tableName = parameters[0];
        String tableColumnIdName = parameters[1];
        this.id = DBUtil.getNextId(tableName, tableColumnIdName);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueIntegerIdentifier other = (UniqueIntegerIdentifier)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public String toString() {
        return this.asString();
    }
}

