/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model;

import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class EntityIdentifierConverter {
    private final Class<? extends EntityIdentifier> entityIdentifierClass;

    public EntityIdentifierConverter(Class<? extends EntityIdentifier> entityIdentifierClass) {
        this.entityIdentifierClass = entityIdentifierClass;
    }

    public <T extends EntityIdentifier> T convertToEntityIdentifier(String idAsString) {
        try {
            EntityIdentifier identifier = (EntityIdentifier)this.getEntityIdentifierClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            identifier.fromString(idAsString);
            return (T)identifier;
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public <T extends EntityIdentifier> Collection<T> convertToEntityIdentifiers(String ... idsAsString) {
        return this.convertToEntityIdentifiers(idsAsString == null ? null : CollectionUtil.asList(idsAsString));
    }

    public <T extends EntityIdentifier> Collection<T> convertToEntityIdentifiers(Collection<String> idsAsString) {
        int size = idsAsString == null ? 0 : idsAsString.size();
        ArrayList<T> identifiers = new ArrayList<T>(size);
        if (size > 0) {
            for (String id : idsAsString) {
                identifiers.add(this.convertToEntityIdentifier(id));
            }
        }
        return identifiers;
    }

    private <T extends EntityIdentifier> Class<T> getEntityIdentifierClass() {
        return this.entityIdentifierClass;
    }
}

