/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.media.streaming;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class StreamingProvidersRegistry {
    private final Map<String, StreamingProvider> registry = new HashMap<String, StreamingProvider>();

    public static StreamingProvidersRegistry get() {
        return ServiceProvider.getService(StreamingProvidersRegistry.class, new Annotation[0]);
    }

    @PostConstruct
    protected void setupDefaults() {
        this.registry.clear();
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.media.streaming");
        Stream.of(settings.getList("streaming.provider.handledIds", new String[0])).map(i -> {
            String urlIdExtractorRegexpPattern = settings.getString(String.format("streaming.provider.%s.urlIdExtractorRegexpPattern", i), "");
            String oembedUrlStringPattern = settings.getString(String.format("streaming.provider.%s.oembedUrlStringPattern", i), "");
            Stream<String> additionalRegexpDetectionParts = Stream.of(settings.getList(String.format("streaming.provider.%s.additionalRegexpDetectionParts", i), new String[0]));
            if (StringUtil.isDefined((String)urlIdExtractorRegexpPattern) && StringUtil.isDefined((String)oembedUrlStringPattern)) {
                List<Pattern> regexpDetectionParts = Stream.concat(Stream.of(i), additionalRegexpDetectionParts).map(Pattern::compile).collect(Collectors.toList());
                boolean justIdInOembedUrl = settings.getBoolean(String.format("streaming.provider.%s.justIdInOembedUrl", i), true);
                return new StreamingProvider((String)i, Pattern.compile(urlIdExtractorRegexpPattern), oembedUrlStringPattern, justIdInOembedUrl, regexpDetectionParts);
            }
            return null;
        }).filter(Objects::nonNull).forEach(this::add);
    }

    public Set<StreamingProvider> getAll() {
        return this.registry.values().stream().collect(Collectors.toUnmodifiableSet());
    }

    public Optional<StreamingProvider> getByName(String name) {
        return Optional.ofNullable(name).map(String::toLowerCase).map(this.registry::get);
    }

    public void add(StreamingProvider streaming) {
        this.registry.put(streaming.getName().toLowerCase(), streaming);
    }

    public Optional<StreamingProvider> getFromUrl(String streamingUrl) {
        return Optional.ofNullable(streamingUrl).filter(StringUtil::isDefined).map(String::toLowerCase).flatMap(u -> this.registry.values().stream().filter(s -> s.getRegexpDetectionParts().stream().map(p -> p.matcher((CharSequence)u)).anyMatch(Matcher::find)).findFirst());
    }

    public Optional<String> getOembedUrl(String streamingUrl) {
        return this.getFromUrl(streamingUrl).flatMap(p -> p.extractStreamingId(streamingUrl).map(i -> String.format(p.getOembedUrlStringPattern(), i)));
    }
}

