/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class TemporalFormatter {
    private static final String DATE_BUNDLE = "org.silverpeas.util.date.multilang.date";
    private static final DateTimeFormatter flexibleFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm:ss.n[XXX]['['VV']']]");

    private TemporalFormatter() {
    }

    public static Temporal toTemporal(String iso8601DateTime, boolean strict) {
        Objects.requireNonNull(iso8601DateTime);
        try {
            return (Temporal)flexibleFormatter.parseBest(iso8601DateTime, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from, LocalDate::from);
        }
        catch (DateTimeParseException e) {
            if (strict) {
                throw e;
            }
            return null;
        }
    }

    public static String toIso8601(Temporal temporal, boolean withSeconds) {
        return TemporalFormatter.toIso8601(temporal, withSeconds, true);
    }

    public static String toBaseIso8601(Temporal temporal, boolean withSeconds) {
        return TemporalFormatter.toIso8601(temporal, withSeconds, false);
    }

    public static String toLocalized(Temporal temporal, String language) {
        Objects.requireNonNull(temporal);
        Objects.requireNonNull(language);
        Temporal temporalValue = temporal instanceof Instant ? OffsetDateTime.ofInstant((Instant)temporal, ZoneId.systemDefault()) : temporal;
        String pattern = temporal.isSupported(ChronoUnit.HOURS) ? TemporalFormatter.getDateTimePattern(language) : TemporalFormatter.getDatePattern(language);
        return DateTimeFormatter.ofPattern(pattern).format(temporalValue);
    }

    public static String toLocalizedTime(Temporal temporal, String language) {
        Objects.requireNonNull(temporal);
        Objects.requireNonNull(language);
        String result = temporal.isSupported(ChronoUnit.HOURS) ? DateTimeFormatter.ofPattern(TemporalFormatter.getTimePattern(language)).format(temporal) : "";
        return result;
    }

    public static String toLocalizedDate(Temporal temporal, ZoneId zoneId, String language) {
        LocalDate localDate = TemporalConverter.asLocalDate(temporal, zoneId);
        return TemporalFormatter.toLocalized(localDate, language);
    }

    public static String toLocalized(Temporal temporal, ZoneId zoneId, String language) {
        String formatted;
        if (!temporal.isSupported(ChronoUnit.HOURS) || temporal instanceof ChronoZonedDateTime && ((ChronoZonedDateTime)temporal).getZone().equals(zoneId) || temporal.isSupported(ChronoField.OFFSET_SECONDS) && temporal.get(ChronoField.OFFSET_SECONDS) == ZonedDateTime.now(zoneId).get(ChronoField.OFFSET_SECONDS)) {
            formatted = TemporalFormatter.toLocalized(temporal, language);
        } else {
            ZoneId actualZoneId = TemporalConverter.asZonedDateTime(temporal).getZone();
            String pattern = TemporalFormatter.getDateTimePattern(language);
            formatted = TemporalFormatter.toZonedFormat(pattern, temporal, actualZoneId);
        }
        return formatted;
    }

    public static String toLocalizedTime(Temporal temporal, ZoneId zoneId, String language) {
        if (temporal.isSupported(ChronoUnit.HOURS) && temporal.get(ChronoField.OFFSET_SECONDS) != ZonedDateTime.now(zoneId).get(ChronoField.OFFSET_SECONDS)) {
            ZoneId actualZoneId = TemporalConverter.asZonedDateTime(temporal).getZone();
            String pattern = TemporalFormatter.getTimePattern(language);
            return TemporalFormatter.toZonedFormat(pattern, temporal, actualZoneId);
        }
        return TemporalFormatter.toLocalizedTime(temporal, language);
    }

    private static String toIso8601(Temporal temporal, boolean withSeconds, boolean extended) {
        Objects.requireNonNull(temporal);
        if (!temporal.isSupported(ChronoUnit.HOURS)) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format(temporal);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2);
        if (withSeconds) {
            builder.optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
        }
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            builder.parseLenient();
            if (extended) {
                builder.appendOffsetId();
            } else {
                builder.appendOffset("+HHMM", "Z");
            }
            builder.parseStrict();
        }
        return builder.toFormatter().format(temporal);
    }

    private static String toZonedFormat(String pattern, Temporal temporal, ZoneId actualZoneId) {
        return new DateTimeFormatterBuilder().appendPattern(pattern).appendLiteral(" (").parseCaseSensitive().appendZoneOrOffsetId().appendLiteral(")").toFormatter().withZone(actualZoneId).format(temporal);
    }

    private static String getDatePattern(String locale) {
        return ResourceLocator.getLocalizationBundle((String)DATE_BUNDLE, (String)locale).getString("dateOutputFormat");
    }

    private static String getTimePattern(String locale) {
        return ResourceLocator.getLocalizationBundle((String)DATE_BUNDLE, (String)locale).getString("hourOutputFormat");
    }

    private static String getDateTimePattern(String locale) {
        return ResourceLocator.getLocalizationBundle((String)DATE_BUNDLE, (String)locale).getString("dateTimeOutputFormat");
    }
}

