/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.tracking;

import java.util.Arrays;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;

public class TrackedApplications {
    private static final String ALL_APPS = "all";
    private static final String NO_APPS = "none";
    public static final TrackedApplications NONE = new TrackedApplications("none");
    public static final TrackedApplications ALL = new TrackedApplications("all");
    private final String[] apps;

    public static TrackedApplications track(String ... apps) {
        if (apps == null || apps.length == 0 || apps.length == 1 && apps[0].equalsIgnoreCase(NO_APPS)) {
            return NONE;
        }
        if (apps.length == 1 && apps[0].equalsIgnoreCase(ALL_APPS)) {
            return ALL;
        }
        return new TrackedApplications(apps);
    }

    private TrackedApplications(String ... apps) {
        this.apps = (String[])Stream.of(apps).distinct().map(String::trim).map(String::toLowerCase).sorted(String::compareTo).toArray(String[]::new);
        if (apps.length > 1 && (this.contains(apps, ALL_APPS) || this.contains(apps, NO_APPS) || this.contains(apps, ""))) {
            throw new IllegalArgumentException("Either passes application names or NONE or ALL");
        }
    }

    public boolean isTracked(String appId) {
        String appName = SilverpeasComponentInstance.getComponentName(appId);
        return this.apps != null && (this.apps[0].equals(ALL_APPS) || this.contains(this.apps, appName));
    }

    private boolean contains(String[] apps, String app) {
        return Arrays.binarySearch(apps, app, String::compareToIgnoreCase) >= 0;
    }
}

