/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.documenttemplate;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.kernel.util.StringUtil;

public class DocumentTemplateRestrictionFilter {
    private final MemoizedSupplier<Set<String>> spaceIdsFromInstanceId = new MemoizedSupplier(() -> OrganizationController.get().getPathToComponent(this.instanceId).stream().map(SpaceInstLight::getId).collect(Collectors.toSet()));
    private String instanceId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applyOn(DocumentTemplate documentTemplate) {
        List<String> restrictedToSpaceIds = documentTemplate.getRestrictedToSpaceIds();
        if (restrictedToSpaceIds.isEmpty()) return true;
        if (!restrictedToSpaceIds.stream().anyMatch(this.getSpaceIds()::contains)) return false;
        return true;
    }

    public DocumentTemplateRestrictionFilter setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    private Set<String> getSpaceIds() {
        return StringUtil.isDefined((String)this.instanceId) ? (Set)this.spaceIdsFromInstanceId.get() : Set.of();
    }
}

