/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.documenttemplate;

import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.documenttemplate.DocumentTemplateRepository;
import org.silverpeas.core.documenttemplate.DocumentTemplateService;

@Service
public class DefaultDocumentTemplateService
implements DocumentTemplateService {
    @Inject
    private DocumentTemplateRepository repository;

    @Override
    public Optional<DocumentTemplate> getById(String id) {
        return this.repository.getById(id);
    }

    @Override
    public DocumentTemplate put(DocumentTemplate documentTemplate, InputStream content) {
        if (documentTemplate.isPersisted()) {
            return this.repository.update(documentTemplate, content);
        }
        documentTemplate.setId(UUID.randomUUID().toString());
        if (documentTemplate.getPosition() < 0) {
            documentTemplate.setPosition(this.repository.streamAll().map(DocumentTemplate::getPosition).max(Comparator.comparing(i -> i)).orElse(-1) + 1);
        }
        return this.repository.create(documentTemplate, content);
    }

    @Override
    public void remove(DocumentTemplate documentTemplate) {
        this.repository.delete(documentTemplate);
    }

    @Override
    public List<DocumentTemplate> listAll() {
        return this.repository.streamAll().sorted(Comparator.comparing(DocumentTemplate::getPosition).thenComparing(DocumentTemplate::getId)).collect(Collectors.toList());
    }
}

