/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.timeout;

import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.workflow.api.ProcessInstanceManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.engine.WorkflowEngineTask;
import org.silverpeas.core.workflow.engine.event.TimeoutEventImpl;
import org.silverpeas.core.workflow.engine.instance.ActionAndState;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class TimeoutManagerImpl
implements Initialization,
SchedulerEventListener {
    @Inject
    private ProcessInstanceManager manager;
    private static final String TIMEOUT_MANAGER_JOB_NAME = "WorkflowTimeoutManager";

    public void init() {
        try {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.workflow.engine.schedulerSettings");
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            if (scheduler.isJobScheduled(TIMEOUT_MANAGER_JOB_NAME)) {
                scheduler.unscheduleJob(TIMEOUT_MANAGER_JOB_NAME);
            }
            String cronString = settings.getString("timeoutSchedule");
            JobTrigger trigger = JobTrigger.triggerAt((String)cronString);
            scheduler.scheduleJob(TIMEOUT_MANAGER_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void doTimeoutManagement() {
        try {
            SilverpeasList<ProcessInstance> instances = this.manager.getTimeOutProcessInstances();
            Date now = new Date();
            for (ProcessInstance instance : instances) {
                ComponentInstLight componentInstLight = Administration.get().getComponentInstLight(instance.getModelId());
                if (componentInstLight == null || componentInstLight.isRemoved()) continue;
                this.addTimeoutRequest(now, instance);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void addTimeoutRequest(Date now, ProcessInstance instance) {
        try {
            ActionAndState timeoutActionAndState = instance.getTimeOutAction(now);
            TimeoutEventImpl event = new TimeoutEventImpl(instance, timeoutActionAndState.getState(), timeoutActionAndState.getAction());
            WorkflowEngineTask.addTimeoutRequest(event);
        }
        catch (WorkflowException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doTimeoutManagement();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job {0} was not successful", new Object[]{anEvent.getJobExecutionContext().getJobName()});
    }
}

