/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.workflow.api.ProcessModelManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.DataFolder;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.Forms;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.engine.model.ProcessModelImpl;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Singleton
public class ProcessModelManagerImpl
implements ProcessModelManager {
    private static final String SELECT_QUERY = "select distinct modelId from SB_Workflow_ProcessInstance";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.workflow.engine.settings");
    private final Map<String, ProcessModel> models = new HashMap<String, ProcessModel>();
    private JAXBContext jaxbContext = null;

    @PostConstruct
    private void setup() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProcessModelImpl.class});
        }
        catch (JAXBException e) {
            SilverLogger.getLogger((Object)this).error("Cannot initialize jaxbContext", (Throwable)e);
        }
    }

    @Override
    public List<String> listProcessModels() throws WorkflowException {
        try {
            return this.findProcessModels(this.getProcessModelDir());
        }
        catch (IOException | RuntimeException e) {
            throw new WorkflowException("WorkflowManager.getProcessModels", "WorkflowEngine.EX_GETTING_RPOCES_MODELS_FAILED", "Workflow Dir : " + this.getProcessModelDir(), e);
        }
    }

    private List<String> findProcessModels(String strProcessModelDir) throws IOException {
        Iterator subFoldersIterator = FileFolderManager.getAllSubFolder((String)strProcessModelDir).iterator();
        Iterator currentDirModelsIterator = FileFolderManager.getAllFile((String)strProcessModelDir).iterator();
        ArrayList<String> processModels = new ArrayList<String>();
        while (subFoldersIterator.hasNext()) {
            File subFolder = (File)subFoldersIterator.next();
            Iterator<String> subFolderModelsIterator = this.findProcessModels(subFolder.getCanonicalPath()).iterator();
            while (subFolderModelsIterator.hasNext()) {
                processModels.add(subFolder.getName() + File.separatorChar + subFolderModelsIterator.next());
            }
        }
        while (currentDirModelsIterator.hasNext()) {
            String name = ((File)currentDirModelsIterator.next()).getName();
            if (!name.endsWith(".xml")) continue;
            processModels.add(name);
        }
        return processModels;
    }

    @Override
    public ProcessModel getProcessModel(String modelId) throws WorkflowException {
        ProcessModel cachedModel = this.getCachedProcessModel(modelId);
        if (cachedModel != null) {
            return cachedModel;
        }
        String fileName = AdministrationServiceProvider.getAdminService().getComponentParameterValue(modelId, "XMLFileName");
        if (fileName == null) {
            throw new WorkflowException("ProcessModelManagerImpl.getProcessModel", "workflowEngine.EX_NO_XML_FILENAME_FOUND", "model/peas id : " + modelId);
        }
        ProcessModelImpl model = (ProcessModelImpl)this.loadProcessModel(fileName);
        model.setModelId(modelId);
        this.cacheProcessModel(modelId, model);
        return model;
    }

    @Override
    public ProcessModel createProcessModelDescriptor() {
        return new ProcessModelImpl();
    }

    @Override
    public ProcessModel createProcessModel(String processFileName, String peasId) throws WorkflowException {
        ProcessModel model;
        Objects.requireNonNull(processFileName, "The process model file is null!");
        try {
            model = this.loadProcessModel(processFileName);
            model.setModelId(peasId);
            DataFolder folder = model.getDataFolder();
            RecordTemplate template = folder.toRecordTemplate(null, null, true);
            this.getGenericRecordSetManager().createRecordSet(model.getFolderRecordSetName(), template);
            Forms forms = model.getForms();
            if (forms != null) {
                Iterator<Form> iterForm = forms.iterateForm();
                while (iterForm.hasNext()) {
                    Form form = iterForm.next();
                    template = form.toRecordTemplate(null, null);
                    this.getGenericRecordSetManager().createRecordSet(model.getFormRecordSetName(form.getName()), template);
                }
            }
        }
        catch (FormException | WorkflowException fe) {
            throw new WorkflowException("ProcessModelManagerImpl.createProcessModel", "workflowEngine.EX_ERR_INSTANCIATING_MODEL", "Process FileName : " + processFileName, (Exception)fe);
        }
        return model;
    }

    @Override
    public void deleteProcessModel(String instanceId) throws WorkflowException {
        Objects.requireNonNull(instanceId);
        ProcessModel model = this.getProcessModel(instanceId);
        String formName = null;
        try {
            formName = model.getFolderRecordSetName();
            this.getGenericRecordSetManager().removeRecordSet(formName);
            Forms forms = model.getForms();
            if (forms != null) {
                Iterator<Form> iterForm = forms.iterateForm();
                while (iterForm.hasNext()) {
                    formName = iterForm.next().getName();
                    this.getGenericRecordSetManager().removeRecordSet(model.getFormRecordSetName(formName));
                }
            }
        }
        catch (FormException fe) {
            throw new WorkflowException("ProcessModelManagerImpl.deleteProcessModel", "workflowEngine.EX_ERR_UNINSTANCIATING_MODEL", "instanceId : " + instanceId + ", formName = " + formName, (Exception)((Object)fe));
        }
    }

    @Override
    public void deleteProcessModelDescriptor(String strProcessModelFileName) throws WorkflowException {
        Objects.requireNonNull(strProcessModelFileName);
        try {
            File workflowsDirectory = new File(this.getProcessModelDir());
            File file = new File(workflowsDirectory, strProcessModelFileName);
            File directory = file.getParentFile();
            if (directory.equals(workflowsDirectory)) {
                FileFolderManager.deleteFile((String)(this.getProcessModelDir() + strProcessModelFileName));
            } else {
                FileUtil.forceDeletion((File)directory);
            }
            this.clearProcessModelCache();
        }
        catch (Exception e) {
            throw new WorkflowException("WorkflowManager.getProcessModels", "WorkflowEngine.EX_GETTING_RPOCES_MODELS_FAILED", "Process Model File name : " + strProcessModelFileName, e);
        }
    }

    @Override
    public ProcessModel loadProcessModel(String processFileName) throws WorkflowException {
        boolean debugMode = settings.getBoolean("DebugMode", false);
        String processPath = this.getProcessPath(processFileName);
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            ProcessModelImpl process = (ProcessModelImpl)unmarshaller.unmarshal(new File(processPath));
            if (debugMode) {
                String debugFile = this.getProcessPath("debug." + new Date().getTime() + ".xml");
                Marshaller mar = this.jaxbContext.createMarshaller();
                mar.setProperty("jaxb.encoding", (Object)"UTF-8");
                mar.setProperty("jaxb.formatted.output", (Object)true);
                mar.marshal((Object)process, new File(debugFile));
            }
            return process;
        }
        catch (JAXBException e) {
            throw new WorkflowException("ProcessModelManagerImpl.loadProcessModel", "workflowEngine.EX_ERR_LOAD_XML_MAPPING", "Process path : " + processPath, (Exception)((Object)e));
        }
    }

    @Override
    public void saveProcessModel(ProcessModel process, String processFileName) throws WorkflowException {
        String schemaFileName = settings.getString("ProcessModelSchemaFileURL", null);
        String processPath = this.getProcessPath(processFileName);
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)schemaFileName);
            marshaller.marshal((Object)process, new File(processPath));
            this.clearProcessModelCache();
        }
        catch (JAXBException e) {
            throw new WorkflowException("ProcessModelManagerImpl.saveProcessModel", "workflowEngine.EX_ERR_LOAD_XML_MAPPING", "Process path = " + processPath, (Exception)((Object)e));
        }
    }

    @Override
    public String getProcessModelDir() {
        Object dir = FileUtil.convertPathToServerOS((String)settings.getString("ProcessModelDir", null));
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separatorChar;
        }
        return dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getAllPeasIds() throws WorkflowException {
        String[] stringArray;
        Connection con = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> peasIds = new ArrayList<String>();
            con = this.getConnection();
            prepStmt = con.prepareStatement(SELECT_QUERY);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                peasIds.add(rs.getString(1));
            }
            stringArray = peasIds.toArray(new String[0]);
        }
        catch (SQLException se) {
            try {
                throw new WorkflowException("ProcessModelManagerImpl.getAllPeasId", "workflowEngine.EX_ERR_GET_ALL_PEAS_IDS", "sql query : select distinct modelId from SB_Workflow_ProcessInstance", (Exception)se);
            }
            catch (Throwable throwable) {
                try {
                    DBUtil.close(rs, prepStmt);
                    if (con == null) throw throwable;
                    con.close();
                    throw throwable;
                }
                catch (SQLException se2) {
                    SilverLogger.getLogger((Object)this).error((Throwable)se2);
                }
                throw throwable;
            }
        }
        try {
            DBUtil.close((ResultSet)rs, (Statement)prepStmt);
            if (con == null) return stringArray;
            con.close();
            return stringArray;
        }
        catch (SQLException se) {
            SilverLogger.getLogger((Object)this).error((Throwable)se);
        }
        return stringArray;
    }

    private ProcessModel getCachedProcessModel(String modelId) {
        return this.models.get(modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheProcessModel(String modelId, ProcessModel model) {
        Map<String, ProcessModel> map = this.models;
        synchronized (map) {
            this.models.put(modelId, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProcessModelCache() {
        Map<String, ProcessModel> map = this.models;
        synchronized (map) {
            this.models.clear();
        }
    }

    private Connection getConnection() throws WorkflowException {
        try {
            Connection con = DBUtil.openConnection();
            return con;
        }
        catch (SQLException se) {
            throw new WorkflowException("ProcessModelManagerImpl.getConnection()", "root.EX_CONNECTION_OPEN_FAILED", se);
        }
    }

    protected String getProcessPath(String processFileName) {
        Object processModelDir = settings.getString("ProcessModelDir");
        if (!((String)(processModelDir = ((String)processModelDir).replace('\\', '/'))).isEmpty() && !((String)processModelDir).endsWith("/")) {
            processModelDir = (String)processModelDir + "/";
        }
        return (String)processModelDir + processFileName;
    }

    private GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }
}

