/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Column;
import org.silverpeas.core.workflow.api.model.DataFolder;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Presentation;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.engine.datarecord.ActionActorTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ActionDateTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ActionLabelTemplate;
import org.silverpeas.core.workflow.engine.datarecord.IndexedFieldTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ItemTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceDataRecord;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceTemplate;
import org.silverpeas.core.workflow.engine.datarecord.StateTemplate;
import org.silverpeas.core.workflow.engine.datarecord.TitleTemplate;
import org.silverpeas.core.workflow.engine.datarecord.UserInfoTemplate;

public class ProcessInstanceRecordTemplate
extends ProcessInstanceTemplate {
    private static final String ACTION = "action.";
    private final transient ProcessModel processModel;
    private final String role;
    private final String lang;

    public ProcessInstanceRecordTemplate(ProcessModel processModel, String role, String lang) {
        if (role == null) {
            role = "";
        }
        if (lang == null) {
            lang = "";
        }
        this.processModel = processModel;
        this.role = role;
        this.lang = lang;
        this.init();
    }

    public FieldTemplate getFieldTemplate(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = (IndexedFieldTemplate)this.fields.get(fieldName);
        if (indexed == null) {
            throw new FormException("Unknown field " + fieldName, new String[0]);
        }
        return indexed.fieldTemplate;
    }

    @Override
    public FieldTemplate getFieldTemplate(int fieldIndex) throws FormException {
        if (0 <= fieldIndex && fieldIndex < this.fields.size()) {
            return this.getFieldTemplates()[fieldIndex];
        }
        throw new FormException("Unknown field at index " + fieldIndex, new String[0]);
    }

    public int getFieldIndex(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = (IndexedFieldTemplate)this.fields.get(fieldName);
        if (indexed == null) {
            throw new FormException("Unknown field " + fieldName, new String[0]);
        }
        return indexed.index;
    }

    public DataRecord getEmptyRecord() throws FormException {
        throw new FormException("Unsupported operation", new String[0]);
    }

    public boolean checkDataRecord(DataRecord record) {
        if (record instanceof ProcessInstanceDataRecord) {
            ProcessInstanceDataRecord instanceRecord = (ProcessInstanceDataRecord)record;
            return this == instanceRecord.template;
        }
        return false;
    }

    @Override
    public Field[] buildFieldsArray() {
        return new Field[this.fields.size()];
    }

    private void init() {
        this.addField(new TitleTemplate("instance", this.role, this.lang));
        this.addField(new TitleTemplate("instance.title", this.role, this.lang));
        this.addField(new StateTemplate("instance.state", this.processModel, this.role, this.lang));
        Presentation presentation = this.processModel.getPresentation();
        this.addInstanceFields(presentation);
        Item[] items = this.processModel.getDataFolder().getItems();
        this.addFolderFields(items);
        Action[] actions = this.processModel.getActions();
        this.addActionFields(actions);
    }

    private void addActionFields(Action[] actions) {
        DataFolder userInfos = this.processModel.getUserInfos();
        Item[] userItems = null;
        if (userInfos != null) {
            userItems = userInfos.getItems();
        }
        for (Action action : actions) {
            this.addField(new ActionLabelTemplate(ACTION + action.getName(), action, this.role, this.lang));
            this.addField(new ActionLabelTemplate(ACTION + action.getName() + ".label", action, this.role, this.lang));
            this.addField(new ActionDateTemplate(ACTION + action.getName() + ".date", action, this.lang));
            this.addField(new ActionActorTemplate(ACTION + action.getName() + ".actor", action, this.lang));
            if (userItems == null) continue;
            for (Item userItem : userItems) {
                if (userItem == null) continue;
                this.addField(new UserInfoTemplate(ACTION + action.getName() + ".actor." + userItem.getName(), userItem, this.role, this.lang));
            }
        }
    }

    private void addFolderFields(Item[] items) {
        for (Item item : items) {
            if (item == null) continue;
            this.addField(new ItemTemplate("folder." + item.getName(), item, this.role, this.lang));
        }
    }

    private void addInstanceFields(Presentation presentation) {
        if (presentation != null) {
            Column[] columns;
            for (Column column : columns = presentation.getColumns(this.role)) {
                Item item = column.getItem();
                if (item == null) continue;
                this.addField(new ItemTemplate("instance." + item.getName(), item, this.role, this.lang));
            }
        }
    }

    private void addField(FieldTemplate fieldTemplate) {
        this.fields.put(fieldTemplate.getFieldName(), new IndexedFieldTemplate(this.fields.size(), fieldTemplate));
    }
}

