/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.lang.annotation.Annotation;
import javax.annotation.Resource;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.silverpeas.core.notification.system.JMSOperation;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.util.ServiceProvider;

public final class SilverStatisticsSender {
    @Resource(lookup="java:/jms/queue/statisticsQueue")
    private Queue queue;

    public static SilverStatisticsSender get() {
        return (SilverStatisticsSender)ServiceProvider.getService(SilverStatisticsSender.class, (Annotation[])new Annotation[0]);
    }

    private SilverStatisticsSender() {
    }

    public void send(StatType typeOfStats, String message) throws JMSException, NamingException {
        JMSOperation.realize(context -> {
            TextMessage textMsg = context.createTextMessage();
            textMsg.setText(typeOfStats.toString() + "&&&" + message);
            context.createProducer().send((Destination)this.queue, (Message)textMsg);
        });
    }
}

