/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.access.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.silverstatistics.access.dao.HistoryObjectDAO;
import org.silverpeas.core.silverstatistics.access.model.HistoryByUser;
import org.silverpeas.core.silverstatistics.access.model.HistoryCriteria;
import org.silverpeas.core.silverstatistics.access.model.HistoryObjectDetail;
import org.silverpeas.core.silverstatistics.access.model.StatisticRuntimeException;
import org.silverpeas.core.silverstatistics.access.service.StatisticService;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Pair;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultStatisticService
implements StatisticService,
ComponentInstanceDeletion {
    public static final int ACTION_ACCESS = 1;

    protected DefaultStatisticService() {
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new StatisticRuntimeException(e);
        }
    }

    @Override
    public void addStat(String userId, ResourceReference resourceReference, int actionType, String objectType) {
        try (Connection con = this.getConnection();){
            HistoryObjectDAO.add(con, userId, resourceReference, actionType, objectType);
        }
        catch (Exception e) {
            throw new StatisticRuntimeException(e);
        }
    }

    @Override
    public void addStat(String userId, SilverpeasContent content) {
        this.addStat(userId, this.getForeignPK(content), 1, content.getContributionType());
    }

    @Override
    public int getCount(List<ResourceReference> resourceReferences, int action, String objectType) {
        int n;
        block8: {
            Connection con = this.getConnection();
            try {
                n = HistoryObjectDAO.getCount(con, resourceReferences, objectType);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public int getCount(ResourceReference resourceReference, int action, String objectType) {
        int n;
        block8: {
            Connection con = this.getConnection();
            try {
                n = HistoryObjectDAO.getCount(con, resourceReference, objectType);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public int getCount(SilverpeasContent content, int action) {
        return this.getCount(this.getForeignPK(content), content.getContributionType());
    }

    @Override
    public int getCount(ResourceReference resourceReference, String objectType) {
        return this.getCount(resourceReference, 1, objectType);
    }

    @Override
    public int getCount(SilverpeasContent content) {
        return this.getCount(this.getForeignPK(content), content.getContributionType());
    }

    @Override
    public List<HistoryByUser> getHistoryByUser(ResourceReference resourceReference, int action, String objectType) {
        SilverpeasList<HistoryByUser> silverpeasList;
        block8: {
            Connection con = this.getConnection();
            try {
                HistoryCriteria criteria = new HistoryCriteria(action).onResource(resourceReference).ofType(objectType);
                silverpeasList = HistoryObjectDAO.findByUserByCriteria(con, criteria);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return silverpeasList;
    }

    @Override
    public SilverpeasList<HistoryObjectDetail> getHistoryByAction(ResourceReference resourceReference, int action, String objectType, Collection<String> excludedUserIds, PaginationPage pagination) {
        SilverpeasList<HistoryObjectDetail> silverpeasList;
        block9: {
            Connection con = this.getConnection();
            try {
                HistoryCriteria criteria = new HistoryCriteria(action).onResource(resourceReference).ofType(objectType).paginatedBy(pagination);
                if (excludedUserIds != null) {
                    criteria.byExcludingUsers(excludedUserIds);
                }
                silverpeasList = HistoryObjectDAO.findByCriteria(con, criteria);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return silverpeasList;
    }

    @Override
    public SilverpeasList<HistoryObjectDetail> getHistoryByObjectAndUser(ResourceReference resourceReference, int action, String objectType, String userId, PaginationPage paginationPage, HistoryCriteria.QUERY_ORDER_BY orderBy) {
        SilverpeasList<HistoryObjectDetail> silverpeasList;
        block9: {
            Connection con = this.getConnection();
            try {
                HistoryCriteria criteria = new HistoryCriteria(action).onResource(resourceReference).ofType(objectType).aboutUsers(userId).paginatedBy(paginationPage);
                if (orderBy != null) {
                    criteria.orderedBy(orderBy);
                }
                silverpeasList = HistoryObjectDAO.findByCriteria(con, criteria);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return silverpeasList;
    }

    @Override
    public List<HistoryByUser> getHistoryByObject(ResourceReference resourceReference, int action, String objectType) {
        UserDetail[] allUsers = (UserDetail[])OrganizationControllerProvider.getOrganisationController().getAllUsers(resourceReference.getInstanceId());
        return this.getHistoryByObject(resourceReference, action, objectType, allUsers);
    }

    @Override
    public List<HistoryByUser> getHistoryByObject(ResourceReference resourceReference, int action, String objectType, List<String> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return this.getHistoryByObject(resourceReference, action, objectType);
        }
        UserDetail[] users = (UserDetail[])OrganizationControllerProvider.getOrganisationController().getUserDetails(userIds.toArray(new String[0]));
        return this.getHistoryByObject(resourceReference, action, objectType, users);
    }

    private List<HistoryByUser> getHistoryByObject(ResourceReference resourceReference, int action, String objectType, UserDetail[] users) {
        ArrayList<HistoryByUser> allStatsByUser = new ArrayList<HistoryByUser>(this.getHistoryByUser(resourceReference, action, objectType));
        if (users != null && users.length > 0) {
            Set userIds = allStatsByUser.stream().map(HistoryByUser::getUserId).collect(Collectors.toSet());
            Arrays.stream(users).filter(u -> !userIds.contains(u.getId())).forEach(u -> allStatsByUser.add(new HistoryByUser((User)u, null, 0)));
        }
        return allStatsByUser;
    }

    @Override
    public void deleteStats(ResourceReference resourceReference, String objectType) {
        try (Connection con = this.getConnection();){
            HistoryObjectDAO.deleteHistoryByObject(con, resourceReference, objectType);
        }
        catch (Exception e) {
            throw new StatisticRuntimeException(e);
        }
    }

    @Override
    public void deleteStats(SilverpeasContent content) {
        this.deleteStats(this.getForeignPK(content), content.getContributionType());
    }

    @Override
    public void moveStat(ResourceReference toResourceReference, int actionType, String objectType) {
        try (Connection con = this.getConnection();){
            HistoryObjectDAO.move(con, toResourceReference, actionType, objectType);
        }
        catch (Exception e) {
            throw new StatisticRuntimeException(e);
        }
    }

    @Override
    public int getCountByPeriod(List<ResourceReference> refs, int action, String objectType, Date startDate, Date endDate) {
        int nb = 0;
        try (Connection con = this.getConnection();){
            for (ResourceReference aRef : refs) {
                nb += HistoryObjectDAO.getCountByPeriod(con, aRef, objectType, startDate, endDate);
            }
        }
        catch (Exception e) {
            throw new StatisticRuntimeException(e);
        }
        return nb;
    }

    @Override
    public int getCountByPeriodAndUser(List<ResourceReference> refs, String objectType, Date startDate, Date endDate, List<String> userIds) {
        int nb = 0;
        if (!userIds.isEmpty()) {
            Set ids = refs.stream().map(k -> ContributionIdentifier.from((ResourceReference)k, (String)objectType)).collect(Collectors.toSet());
            try (Connection con = this.getConnection();){
                nb += userIds.stream().flatMapToInt(u -> {
                    try {
                        return HistoryObjectDAO.countByPeriodAndUser(con, ids, startDate, endDate, u).mapToInt(Pair::getSecond);
                    }
                    catch (SQLException e) {
                        throw new StatisticRuntimeException(e);
                    }
                }).sum();
            }
            catch (Exception e) {
                throw new StatisticRuntimeException(e);
            }
        }
        return nb;
    }

    @Override
    public int getDistinctCountByPeriod(List<ResourceReference> refs, int action, String objectType, Date startDate, Date endDate) {
        int n;
        block8: {
            Connection con = this.getConnection();
            try {
                List<String> objectIds = HistoryObjectDAO.getListObjectAccessByPeriod(con, refs, objectType, startDate, endDate);
                HashSet<String> distinctObjectIds = new HashSet<String>(objectIds);
                n = distinctObjectIds.size();
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public int getDistinctCountByPeriodUser(List<ResourceReference> refs, int action, String objectType, Date startDate, Date endDate, List<String> userIds) {
        int nb = 0;
        if (userIds != null && !userIds.isEmpty()) {
            HashSet<String> distinctObjectIds = new HashSet<String>(userIds.size());
            try (Connection con = this.getConnection();){
                for (String userId : userIds) {
                    List<String> objectIds = HistoryObjectDAO.getListObjectAccessByPeriodAndUser(con, refs, objectType, startDate, endDate, userId);
                    distinctObjectIds.addAll(objectIds);
                }
                nb = distinctObjectIds.size();
            }
            catch (Exception e) {
                throw new StatisticRuntimeException(e);
            }
        }
        return nb;
    }

    @Override
    public Collection<HistoryObjectDetail> getLastHistoryOfObjectsForUser(String userId, int actionType, String objectType, int nbObjects) {
        Collection<HistoryObjectDetail> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = HistoryObjectDAO.getLastHistoryDetailOfObjectsForUser(con, userId, actionType, objectType, nbObjects);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public <T extends Contribution> Stream<T> filterRead(Collection<T> contributions, String userId) {
        Stream<Contribution> stream;
        block8: {
            Connection con = this.getConnection();
            try {
                Map<ContributionIdentifier, Contribution> indexed = contributions.stream().collect(Collectors.toMap(Contribution::getIdentifier, c -> c));
                stream = HistoryObjectDAO.countByPeriodAndUser(con, indexed.keySet(), null, null, userId).filter(p -> (Integer)p.getSecond() > 0).map(p -> (Contribution)indexed.get(p.getFirst()));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StatisticRuntimeException(e);
                }
            }
            con.close();
        }
        return stream;
    }

    private ResourceReference getForeignPK(SilverpeasContent content) {
        return new ResourceReference(content.getId(), content.getComponentInstanceId());
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection con = this.getConnection();){
            HistoryObjectDAO.deleteStatsOfComponent(con, componentInstanceId);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException("A failure occurred when deleting the statistics relative to the component instance " + componentInstanceId, (Throwable)e);
        }
    }
}

