/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.connect;

import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.impl.LinkedInTemplate;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedInServiceProvider
extends AbstractOAuth2ServiceProvider<LinkedIn> {
    public LinkedInServiceProvider(String clientId, String clientSecret) {
        super((OAuth2Operations)LinkedInServiceProvider.getOAuth2Template(clientId, clientSecret));
    }

    private static OAuth2Template getOAuth2Template(String clientId, String clientSecret) {
        OAuth2Template oAuth2Template = new OAuth2Template(clientId, clientSecret, "https://www.linkedin.com/uas/oauth2/authorization", "https://www.linkedin.com/uas/oauth2/accessToken");
        oAuth2Template.setUseParametersForClientAuthentication(true);
        return oAuth2Template;
    }

    public LinkedIn getApi(String accessToken) {
        return new LinkedInTemplate(accessToken);
    }
}

