/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.springframework.social.linkedin.api.Comment;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.UpdateContent;
import org.springframework.social.linkedin.api.UpdateContentCompany;
import org.springframework.social.linkedin.api.UpdateContentShare;
import org.springframework.social.linkedin.api.UpdateType;
import org.springframework.social.linkedin.api.impl.json.LikesListDeserializer;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;
import org.springframework.social.linkedin.api.impl.json.UpdateTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UpdateActionMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likeable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updateComments")
    @JsonDeserialize(using=CommentsListDeserializer.class)
    List<Comment> updateComments;
    @JsonProperty(value="updateContent")
    @JsonDeserialize(using=UpdateContentDeserializer.class)
    UpdateContent updateContent;

    @JsonCreator
    UpdateActionMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateContentDeserializer
    extends JsonDeserializer<UpdateContent> {
        private UpdateContentDeserializer() {
        }

        public UpdateContent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            JsonNode content = (JsonNode)jp.readValueAs(JsonNode.class);
            JsonNode person = content.get("person");
            JsonNode company = content.get("company");
            if (person != null) {
                return (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentShare>(){}).readValue(person);
            }
            if (company != null) {
                return (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentCompany>(){}).readValue(content);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentsListDeserializer
    extends JsonDeserializer<List<Comment>> {
        private CommentsListDeserializer() {
        }

        public List<Comment> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                return (List)mapper.reader((TypeReference)new TypeReference<List<Comment>>(){}).readValue(dataNode);
            }
            return null;
        }
    }
}

