/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.UpdateType;
import org.springframework.social.linkedin.api.impl.json.LikesListDeserializer;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;
import org.springframework.social.linkedin.api.impl.json.UpdateTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class LinkedInNetworkUpdateMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updatedFields")
    @JsonDeserialize(using=UpdatedFieldsListDeserializer.class)
    List<String> updatedFields;

    @JsonCreator
    LinkedInNetworkUpdateMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdatedFieldsListDeserializer
    extends JsonDeserializer<List<String>> {
        private UpdatedFieldsListDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken()) {
                JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values");
                ArrayList<String> values = new ArrayList<String>();
                for (JsonNode value : dataNode) {
                    values.add(value.get("name").textValue());
                }
                return values;
            }
            return null;
        }
    }
}

