/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.NotAuthorizedException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.web.client.DefaultResponseErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedInErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse response) throws IOException {
        Map<String, Object> errorDetails = this.extractErrorDetailsFromResponse(response);
        String message = (String)errorDetails.get("message");
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.equals((Object)HttpStatus.UNAUTHORIZED)) {
            throw new NotAuthorizedException("linkedIn", message);
        }
        if (statusCode.equals((Object)HttpStatus.FORBIDDEN)) {
            if (message.contains("Throttle")) {
                throw new RateLimitExceededException("linkedin");
            }
            throw new InsufficientPermissionException("linkedin");
        }
        if (statusCode.equals((Object)HttpStatus.NOT_FOUND)) {
            throw new ResourceNotFoundException("linkedin", message);
        }
        this.handleUncategorizedError(response);
    }

    private void handleUncategorizedError(ClientHttpResponse response) {
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            throw new UncategorizedApiException("linkedin", "", (Throwable)e);
        }
    }

    private Map<String, Object> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            return (Map)mapper.readValue(response.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonParseException e) {
            return Collections.emptyMap();
        }
    }
}

