/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.taglib;

import com.sun.portal.portletcontainer.common.URLHelper;
import com.sun.portal.portletcontainer.taglib.BaseURLTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletURLTag
extends BaseURLTag {
    protected String portletMode;
    protected String windowState;
    protected boolean copyCurrentRenderParameters = false;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletURL portletURL = this.createURL(portletResponse);
        if (portletURL == null) {
            throw new JspException("Response must be either RenderResponse or ResourceResponse");
        }
        try {
            if (this.portletMode != null) {
                portletURL.setPortletMode(new PortletMode(this.portletMode.toLowerCase(Locale.ENGLISH)));
            }
            if (this.windowState != null) {
                portletURL.setWindowState(new WindowState(this.windowState.toLowerCase(Locale.ENGLISH)));
            }
            if (this.getSecure() != null) {
                String secure = this.getSecure().toLowerCase(Locale.ENGLISH);
                if (secure.equals("true")) {
                    portletURL.setSecure(true);
                } else if (secure.equals("false")) {
                    portletURL.setSecure(false);
                } else {
                    throw new JspException("invalid value for attribute secure");
                }
            }
            this.setBaseURL((BaseURL)portletURL);
        }
        catch (PortletModeException e) {
            throw new JspException("invalid value for attribute mode", (Throwable)e);
        }
        catch (WindowStateException e) {
            throw new JspException("invalid value for attribute state", (Throwable)e);
        }
        catch (PortletSecurityException e) {
            throw new JspException("invalid value for attribute secure", (Throwable)e);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        if (this.copyCurrentRenderParameters) {
            this.copyCurrentRenderParameters(new HashMap<String, String[]>(portletRequest.getPrivateParameterMap()));
            this.getRemovedParametersList().clear();
        }
        this.setAdditionalParameters(this.getBaseURL());
        String urlString = this.getBaseURL().toString();
        if (this.isEscapeXml(portletRequest)) {
            urlString = URLHelper.escapeURL(urlString);
        }
        if (this.getVar() == null) {
            try {
                this.pageContext.getOut().print(urlString);
            }
            catch (IOException e) {
                throw new JspTagException("Error: IOException while writing: " + e.getMessage());
            }
        } else {
            this.pageContext.setAttribute(this.getVar(), (Object)urlString);
        }
        return 6;
    }

    @Override
    public void setParent(Tag t) {
        super.setParent(t);
        this.portletMode = null;
        this.windowState = null;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this.copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    private void copyCurrentRenderParameters(Map<String, String[]> renderParameterMap) {
        if (!this.getRemovedParametersList().isEmpty()) {
            for (String name : this.getRemovedParametersList()) {
                renderParameterMap.remove(name);
            }
        }
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(this.getBaseURL().getParameterMap());
        Set<Map.Entry<String, String[]>> entries = renderParameterMap.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entries) {
            String renderParameterKey = mapEntry.getKey();
            String[] renderParameterValues = mapEntry.getValue();
            String[] parameterValues = (String[])parameterMap.get(renderParameterKey);
            if (parameterValues != null) {
                ArrayList<String> renderParameterValuesList = new ArrayList<String>(Arrays.asList(renderParameterValues));
                ArrayList<String> parameterValuesList = new ArrayList<String>(Arrays.asList(parameterValues));
                parameterValuesList.addAll(renderParameterValuesList);
                parameterMap.put(renderParameterKey, parameterValuesList.toArray(new String[0]));
                continue;
            }
            parameterMap.put(renderParameterKey, renderParameterValues);
        }
        this.getBaseURL().setParameters(parameterMap);
    }

    public abstract PortletURL createURL(PortletResponse var1);
}

