/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletMetaDataResource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletsResources {
    private Map<String, Map<String, ResourceBundle>> portletResourceMap = null;
    private Map<String, Map<String, PortletMetaDataResource>> portletMetadataResourceMap = null;
    private PortletAppDescriptor portletAppDescriptor = null;
    private static Logger logger = ContainerLogger.getLogger(PortletsResources.class, (String)"PAELogMessages");

    public PortletsResources(PortletAppDescriptor pd) {
        this.portletAppDescriptor = pd;
        this.init();
    }

    private void init() {
        List portlets;
        if (this.getPortletAppD() != null && (portlets = this.getPortletNames()) != null) {
            this.portletResourceMap = new HashMap<String, Map<String, ResourceBundle>>();
            this.portletMetadataResourceMap = new HashMap<String, Map<String, PortletMetaDataResource>>();
            for (String portlet : portlets) {
                this.loadResources(portlet);
            }
        }
    }

    private void loadResources(String portlet) {
        HashMap<String, ResourceBundle> resBundleMap = new HashMap<String, ResourceBundle>();
        HashMap<String, PortletMetaDataResource> metadataBundleMap = new HashMap<String, PortletMetaDataResource>();
        String rbName = this.getResourceBundleName(portlet);
        if (rbName != null && rbName.trim().length() != 0) {
            ResourceBundle bundle;
            List locales = this.getSupportedLocales(portlet);
            if (locales != null && locales.size() > 0) {
                for (String localeString : locales) {
                    Locale thisLocale;
                    ResourceBundle bundle2;
                    String lang = "";
                    String country = "";
                    String variant = "";
                    StringTokenizer tokenizer = new StringTokenizer(localeString, "_");
                    lang = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        country = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        variant = tokenizer.nextToken();
                    }
                    if ((bundle2 = this.loadResource(rbName, thisLocale = new Locale(lang, country, variant))) == null) continue;
                    resBundleMap.put(thisLocale.toString(), bundle2);
                    PortletMetaDataResource pmds = new PortletMetaDataResource(bundle2);
                    if (!pmds.hasData()) continue;
                    metadataBundleMap.put(thisLocale.toString(), pmds);
                }
            }
            if ((bundle = this.loadResource(rbName, Locale.getDefault())) != null) {
                resBundleMap.put(Locale.getDefault().toString(), bundle);
                metadataBundleMap.put(Locale.getDefault().toString(), new PortletMetaDataResource(bundle));
            }
            this.portletResourceMap.put(portlet, resBundleMap);
            this.portletMetadataResourceMap.put(portlet, metadataBundleMap);
        }
    }

    private ResourceBundle loadResource(String rbName, Locale locale) {
        ResourceBundle retval;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            retval = ResourceBundle.getBundle(rbName, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            logger.log(Level.FINE, "PSPL_PAECSPPI0013", rbName);
            retval = null;
        }
        return retval;
    }

    public Map<String, Map<String, ResourceBundle>> getPortletResourceMap() {
        return this.portletResourceMap;
    }

    public Map<String, Map<String, PortletMetaDataResource>> getPortletMetadataResourceMap() {
        return this.portletMetadataResourceMap;
    }

    private PortletAppDescriptor getPortletAppD() {
        return this.portletAppDescriptor;
    }

    private PortletDescriptor getPortletDescriptor(String portlet) {
        return this.getPortletAppD().getPortletsDescriptor().getPortletDescriptor(portlet);
    }

    private List getSupportedLocales(String portlet) {
        return this.getPortletDescriptor(portlet).getSupportedLocales();
    }

    private String getResourceBundleName(String portlet) {
        return this.getPortletDescriptor(portlet).getResourceBundle();
    }

    private List getPortletNames() {
        return this.getPortletAppD().getPortletsDescriptor().getPortletNames();
    }
}

