/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConstraintDescriptor {
    private List<String> displayNames;
    private Map<String, String> displayNameMap;
    private List<String> portletNames;
    private List<String> constraintDescs;
    private String transportGuaranteeType = "NONE";
    private static Logger logger = ContainerLogger.getLogger(SecurityConstraintDescriptor.class, (String)"PCCLogMessages");

    public void load(Element element, String namespaceURI) throws DeploymentDescriptorException {
        Element constraintElement;
        NodeList portletCollectionElements;
        int i;
        NodeList displayNameElements = element.getElementsByTagName("display-name");
        if (displayNameElements.getLength() > 0) {
            this.displayNames = new ArrayList<String>();
            this.displayNameMap = new HashMap<String, String>();
            for (i = 0; i < displayNameElements.getLength(); ++i) {
                String lang;
                Element displayNameElement = (Element)displayNameElements.item(i);
                String displayName = PortletXMLDocumentHelper.getTextTrim(displayNameElement);
                this.displayNames.add(displayName);
                Map<String, String> displayNameAttributes = PortletXMLDocumentHelper.getAttributeTable(displayNameElement);
                Iterator<Map.Entry<String, String>> dnit = displayNameAttributes.entrySet().iterator();
                if (dnit.hasNext()) {
                    while (dnit.hasNext()) {
                        Map.Entry<String, String> entry = dnit.next();
                        lang = entry.getKey();
                        if (!lang.equals("xml:lang")) continue;
                        this.displayNameMap.put(entry.getValue(), displayName);
                    }
                    continue;
                }
                lang = Locale.getDefault().toString().replace('_', '-');
                this.displayNameMap.put(lang, displayName);
            }
        }
        if ((portletCollectionElements = element.getElementsByTagName("portlet-collection")).getLength() > 0) {
            this.portletNames = new ArrayList<String>(portletCollectionElements.getLength());
            for (i = 0; i < portletCollectionElements.getLength(); ++i) {
                Element portletCollectionElement = (Element)portletCollectionElements.item(i);
                NodeList portletNameElements = portletCollectionElement.getElementsByTagName("portlet-name");
                for (int j = 0; j < portletNameElements.getLength(); ++j) {
                    Element portletNameElement = (Element)portletNameElements.item(j);
                    String portletName = PortletXMLDocumentHelper.getTextTrim(portletNameElement);
                    this.portletNames.add(portletName);
                }
            }
        }
        if ((constraintElement = PortletXMLDocumentHelper.getChildElement(element, "user-data-constraint")) == null) {
            logger.warning("PSPL_PCCCSPPCCD0013");
        } else {
            this.constraintDescs = new ArrayList<String>();
            this.transportGuaranteeType = PortletXMLDocumentHelper.getChildTextTrim(constraintElement, "transport-guarantee");
            NodeList descriptionElements = element.getElementsByTagName("description");
            for (int i2 = 0; i2 < descriptionElements.getLength(); ++i2) {
                Element descriptionElement = (Element)descriptionElements.item(i2);
                this.constraintDescs.add(PortletXMLDocumentHelper.getTextTrim(descriptionElement));
            }
        }
    }

    public List<String> getConstrainedPortlets() {
        if (this.portletNames == null) {
            return Collections.emptyList();
        }
        return this.portletNames;
    }

    public String getTransportGuaranteeType() {
        return this.transportGuaranteeType;
    }

    public List getDisplayNames() {
        if (this.displayNames == null) {
            return Collections.emptyList();
        }
        return this.displayNames;
    }

    public Map getDisplayNameMap() {
        if (this.displayNameMap == null) {
            return Collections.emptyMap();
        }
        return this.displayNameMap;
    }

    public List getConstraintDescriptions() {
        if (this.constraintDescs == null) {
            return Collections.emptyList();
        }
        return this.constraintDescs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletDescriptor ");
        sb.append(" display names [");
        Iterator<String> iterator = this.displayNames.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
        }
        sb.append(" ]");
        sb.append(" constrained portlet names [");
        Iterator<String> iterator1 = this.portletNames.iterator();
        while (iterator1.hasNext()) {
            sb.append(iterator1.next());
        }
        sb.append(" ]");
        if (this.transportGuaranteeType != null) {
            sb.append(" transport guarantee type [");
            sb.append(this.transportGuaranteeType);
            sb.append(" ]");
            sb.append(" constrained portlet names [");
            Iterator<String> iterator2 = this.constraintDescs.iterator();
            while (iterator2.hasNext()) {
                sb.append(iterator2.next());
            }
            sb.append(" ]");
        }
        return sb.toString();
    }
}

