/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class FilterChainImpl
implements FilterChain {
    private Portlet portlet = null;
    private List filterList = null;
    private int pos = 0;

    public FilterChainImpl(Portlet p, List filters) {
        this.portlet = p;
        this.filterList = filters != null ? filters : Collections.EMPTY_LIST;
    }

    public void doFilter(ActionRequest aReq, ActionResponse aRes) throws IOException, PortletException {
        if (this.pos < this.filterList.size()) {
            ActionFilter filter = (ActionFilter)this.filterList.get(this.pos++);
            filter.doFilter(aReq, aRes, (FilterChain)this);
            return;
        }
        this.portlet.processAction(aReq, aRes);
    }

    public void doFilter(RenderRequest rReq, RenderResponse rRes) throws IOException, PortletException {
        if (this.pos < this.filterList.size()) {
            RenderFilter filter = (RenderFilter)this.filterList.get(this.pos++);
            filter.doFilter(rReq, rRes, (FilterChain)this);
            return;
        }
        this.portlet.render(rReq, rRes);
    }

    public void doFilter(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        if (this.pos < this.filterList.size()) {
            EventFilter filter = (EventFilter)this.filterList.get(this.pos++);
            filter.doFilter(eventRequest, eventResponse, (FilterChain)this);
            return;
        }
        ((EventPortlet)this.portlet).processEvent(eventRequest, eventResponse);
    }

    public void doFilter(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (this.pos < this.filterList.size()) {
            ResourceFilter filter = (ResourceFilter)this.filterList.get(this.pos++);
            filter.doFilter(resourceRequest, resourceResponse, (FilterChain)this);
            return;
        }
        ((ResourceServingPortlet)this.portlet).serveResource(resourceRequest, resourceResponse);
    }
}

