/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service.caching.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.service.ServiceAdapter;
import com.sun.portal.container.service.caching.CachingService;
import com.sun.portal.container.service.caching.NoSuchCachedContentException;
import com.sun.portal.container.service.caching.PortletCacheEntry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingServiceImpl
extends ServiceAdapter
implements CachingService {
    private static Logger logger = ContainerLogger.getLogger(CachingServiceImpl.class, "CLogMessages");
    public static final String CACHED_PORTLETS = "javax.portlet.cache_portlets";
    private static final String DESCRIPTION = "Caches the portlet content";

    @Override
    public String getName() {
        return "com.sun.portal.container.service.CachingService";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean isCachingEnabled(ContainerRequest containerRequest) {
        boolean cachingEnabled = containerRequest.getUserID() != null;
        return cachingEnabled;
    }

    @Override
    public PortletCacheEntry getCachedPortlet(ContainerRequest containerRequest) {
        PortletCacheEntry cacheEntry = null;
        EntityID portletEntityID = containerRequest.getEntityID();
        ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> privateCachedPortlets = this.getPrivateCachedPortletsMap(containerRequest);
        PortletCacheEntry pce = this.getPortletCacheEntry(containerRequest, privateCachedPortlets, portletEntityID);
        boolean isPublic = false;
        if (pce == null) {
            isPublic = true;
            ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> publicCachedPortlets = this.getPublicCachedPortletsMap(containerRequest);
            pce = this.getPortletCacheEntry(containerRequest, publicCachedPortlets, portletEntityID);
        }
        if (pce != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSC_CSPCS014", new Object[]{portletEntityID, Boolean.toString(isPublic)});
            }
            long now = System.currentTimeMillis();
            if (pce.getExpirationTime() > now) {
                pce.setNeedsValidation(false);
                cacheEntry = pce;
            } else if (pce.getETag() != null) {
                pce.setNeedsValidation(true);
                cacheEntry = pce;
            } else {
                this.removeCachedPortlet(containerRequest);
            }
            if (cacheEntry != null && !containerRequest.getLocale().toString().equals(pce.getLocaleString())) {
                this.removeCachedPortlet(containerRequest);
                cacheEntry = null;
            }
        }
        return cacheEntry;
    }

    @Override
    public void putCachedPortlet(ContainerRequest containerRequest, PortletCacheEntry cacheEntry, boolean isPublic) {
        EntityID portletEntityID = containerRequest.getEntityID();
        ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> cachedPortlets = null;
        cachedPortlets = isPublic ? this.getPublicCachedPortletsMap(containerRequest) : this.getPrivateCachedPortletsMap(containerRequest);
        ConcurrentHashMap<String, PortletCacheEntry> cacheEntries = (ConcurrentHashMap<String, PortletCacheEntry>)cachedPortlets.get(portletEntityID);
        if (cacheEntries == null) {
            cacheEntries = new ConcurrentHashMap<String, PortletCacheEntry>();
        }
        cacheEntries.put(containerRequest.getLocale().toString(), cacheEntry);
        cachedPortlets.put(portletEntityID, cacheEntries);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PSC_CSPCS015", new Object[]{portletEntityID, Boolean.toString(isPublic)});
        }
    }

    @Override
    public void removeCachedPortlet(ContainerRequest containerRequest) {
        EntityID portletEntityID = containerRequest.getEntityID();
        ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> privateCachedPortlets = this.getPrivateCachedPortletsMap(containerRequest);
        if (privateCachedPortlets.containsKey(portletEntityID)) {
            ConcurrentMap cacheEntries;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSC_CSPCS016", new Object[]{portletEntityID, "Private"});
            }
            if ((cacheEntries = (ConcurrentMap)privateCachedPortlets.get(portletEntityID)) != null) {
                cacheEntries.remove(containerRequest.getLocale().toString());
            } else {
                privateCachedPortlets.remove(portletEntityID);
            }
        } else {
            ConcurrentMap cacheEntries;
            ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> publicCachedPortlets = this.getPublicCachedPortletsMap(containerRequest);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSC_CSPCS016", new Object[]{portletEntityID, "Public"});
            }
            if ((cacheEntries = (ConcurrentMap)publicCachedPortlets.get(portletEntityID)) != null) {
                cacheEntries.remove(containerRequest.getLocale().toString());
            } else {
                publicCachedPortlets.remove(portletEntityID);
            }
        }
    }

    @Override
    public void removeAllCachedPortlets(ContainerRequest containerRequest) {
        this.getPublicCachedPortletsMap(containerRequest).clear();
        this.getPrivateCachedPortletsMap(containerRequest).clear();
    }

    @Override
    public boolean isCacheExpired(ContainerRequest containerRequest) throws IllegalStateException, NoSuchCachedContentException {
        boolean cacheExpired = true;
        EntityID portletEntityID = containerRequest.getEntityID();
        ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> privateCachedPortlets = this.getPrivateCachedPortletsMap(containerRequest);
        PortletCacheEntry pce = this.getPortletCacheEntry(containerRequest, privateCachedPortlets, portletEntityID);
        if (pce == null) {
            ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> publicCachedPortlets = this.getPublicCachedPortletsMap(containerRequest);
            pce = this.getPortletCacheEntry(containerRequest, publicCachedPortlets, portletEntityID);
        }
        if (pce != null) {
            if (pce.getCacheType() == 1) {
                long now = System.currentTimeMillis();
                if (pce.getExpirationTime() > now) {
                    cacheExpired = false;
                }
            }
        } else {
            throw new NoSuchCachedContentException("Cache entry is not found. EntityID:" + portletEntityID);
        }
        return cacheExpired;
    }

    private ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> getPrivateCachedPortletsMap(ContainerRequest containerRequest) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        ConcurrentHashMap cachedPortlets = (ConcurrentHashMap)portletWindowContext.getProperty(CACHED_PORTLETS);
        if (cachedPortlets == null) {
            cachedPortlets = new ConcurrentHashMap();
            portletWindowContext.setProperty(CACHED_PORTLETS, cachedPortlets);
        }
        return cachedPortlets;
    }

    private ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> getPublicCachedPortletsMap(ContainerRequest containerRequest) {
        ServletContext context = this.getServletContext();
        ConcurrentHashMap cachedPortlets = (ConcurrentHashMap)context.getAttribute(CACHED_PORTLETS);
        if (cachedPortlets == null) {
            cachedPortlets = new ConcurrentHashMap();
            context.setAttribute(CACHED_PORTLETS, cachedPortlets);
        }
        return cachedPortlets;
    }

    private PortletCacheEntry getPortletCacheEntry(ContainerRequest containerRequest, ConcurrentMap<EntityID, ConcurrentMap<String, PortletCacheEntry>> cachedPortlets, EntityID portletEntityID) {
        PortletCacheEntry pce = null;
        ConcurrentMap cacheEntries = (ConcurrentMap)cachedPortlets.get(portletEntityID);
        if (cacheEntries != null) {
            pce = (PortletCacheEntry)cacheEntries.get(containerRequest.getLocale().toString());
        }
        return pce;
    }
}

