/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.thesaurus.service;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.thesaurus.model.Jargon;
import org.silverpeas.core.pdc.thesaurus.model.Synonym;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.pdc.thesaurus.model.Vocabulary;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ThesaurusService {
    private static final String VOCABULARY_SYNONYMS_DELETION_FAILED = "Vocabulary synonyms deletion failed";
    private static final String VOCABULARY_JARGON_DELETION_FAILED = "Vocabulary jargon deletion failed";
    private static final String CANNOT_GET_VOCABULARY_JARGON = "Cannot get vocabulary jargon";
    private static final String VOCABULARY_JARGON_CREATION_FAILED = "Vocabulary jargon creation failed";
    private static final String VOCA_ID = "idVoca";
    private static final String TREE_ID = "idTree";
    private static final String TERM_ID = "idTerm";
    private static final String ID_USER = "idUser";
    private SilverpeasBeanDAO<Vocabulary> vocabularyDao = null;
    private SilverpeasBeanDAO<Synonym> synonymDao = null;
    private SilverpeasBeanDAO<Jargon> jargonDao = null;

    protected ThesaurusService() {
    }

    public static ThesaurusService getInstance() {
        return (ThesaurusService)ServiceProvider.getService(ThesaurusService.class, (Annotation[])new Annotation[0]);
    }

    private SilverpeasBeanDAO<Vocabulary> getVocabularyDao() throws PersistenceException {
        if (this.vocabularyDao == null) {
            this.vocabularyDao = SilverpeasBeanDAOFactory.getDAO(Vocabulary.class);
        }
        return this.vocabularyDao;
    }

    private SilverpeasBeanDAO<Synonym> getSynonymDao() throws PersistenceException {
        if (this.synonymDao == null) {
            this.synonymDao = SilverpeasBeanDAOFactory.getDAO(Synonym.class);
        }
        return this.synonymDao;
    }

    private SilverpeasBeanDAO<Jargon> getJargonDao() throws PersistenceException {
        if (this.jargonDao == null) {
            this.jargonDao = SilverpeasBeanDAOFactory.getDAO(Jargon.class);
        }
        return this.jargonDao;
    }

    public Collection<Vocabulary> getListVocabulary() throws ThesaurusException {
        try {
            return this.getVocabularyDao().findBy(BeanCriteria.emptyCriteria());
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabularies", e);
        }
    }

    public Vocabulary getVocabulary(long idVoca) throws ThesaurusException {
        Vocabulary vocab;
        try {
            IdPK pk = new IdPK();
            pk.setIdAsLong(idVoca);
            vocab = (Vocabulary)this.getVocabularyDao().findByPrimaryKey((WAPrimaryKey)pk);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabulary", e);
        }
        return vocab;
    }

    public long createVocabulary(Vocabulary voca) throws ThesaurusException {
        try {
            IdPK pkV = (IdPK)this.getVocabularyDao().add((SilverpeasEntityBean)voca);
            return pkV.getIdAsLong();
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot create vocabulary", e);
        }
    }

    public boolean existVocabulary(String name) throws ThesaurusException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)"name", (Object)this.encode(name));
            Collection vocabs = this.getVocabularyDao().findBy(criteria);
            return !vocabs.isEmpty();
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabulary of name = " + name, e);
        }
    }

    private String encode(String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '\'') {
                str.append("''");
                continue;
            }
            str.append(name.charAt(i));
        }
        return str.toString();
    }

    public void updateVocabulary(Vocabulary voca) throws ThesaurusException {
        try {
            this.getVocabularyDao().update((SilverpeasEntityBean)voca);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Vocabulary update failed", e);
        }
    }

    public void deleteVocabulary(long idVoca) throws ThesaurusException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
            this.deleteVocaSynonyms(con, idVoca);
            this.deleteVocaJargons(con, idVoca);
            SilverpeasBeanDAO<Vocabulary> daoV = this.getVocabularyDao();
            IdPK pk = new IdPK();
            pk.setIdAsLong(idVoca);
            daoV.remove(con, (WAPrimaryKey)pk);
            con.commit();
        }
        catch (Exception e) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception e1) {
                throw new ThesaurusException("Vocabulary deletion failed", e1);
            }
            throw new ThesaurusException("Vocabulary deletion failed", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void deleteVocaSynonyms(Connection con, long idVoca) throws ThesaurusException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca);
            this.getSynonymDao().removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_SYNONYMS_DELETION_FAILED, e);
        }
    }

    private void deleteVocaJargons(Connection con, long idVoca) throws ThesaurusException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca);
            this.getJargonDao().removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_DELETION_FAILED, e);
        }
    }

    public void deleteJargons(Collection<Jargon> jargons) throws ThesaurusException {
        try {
            for (Jargon jargon : jargons) {
                this.deleteJargon(jargon.getPK().getId());
            }
        }
        catch (ThesaurusException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_DELETION_FAILED, (Throwable)((Object)e));
        }
    }

    private void deleteJargon(String idJargon) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            IdPK pk = new IdPK();
            pk.setId(idJargon);
            daoJ.remove((WAPrimaryKey)pk);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_DELETION_FAILED, e);
        }
    }

    private void createSynonyms(Connection con, Collection<Synonym> synonyms) throws ThesaurusException {
        try {
            for (Synonym synonyme : synonyms) {
                if (!StringUtil.isDefined((String)synonyme.getName())) continue;
                this.createSynonym(con, synonyme);
            }
        }
        catch (ThesaurusException e) {
            throw new ThesaurusException("Vocabulary synonyms creation failed", (Throwable)((Object)e));
        }
    }

    private void createSynonym(Connection con, Synonym synonym) throws ThesaurusException {
        try {
            this.getSynonymDao().add(con, (SilverpeasEntityBean)synonym);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Vocabulary synonyms creation failed", e);
        }
    }

    public Collection<Synonym> getSynonyms(long idVoca, long idTree, long idTerm) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca).and(TREE_ID, (Object)idTree).and(TERM_ID, (Object)idTerm);
            return daoS.findBy(criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabulary synonyms", e);
        }
    }

    public void updateSynonyms(Collection<Synonym> synonyms) throws ThesaurusException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
            Iterator<Synonym> i = synonyms.iterator();
            if (i.hasNext()) {
                Synonym synonyme = i.next();
                long idVoca = synonyme.getIdVoca();
                long idTree = synonyme.getIdTree();
                long idTerm = synonyme.getIdTerm();
                this.deleteSynonyms(con, idVoca, idTree, idTerm);
            }
            this.createSynonyms(con, synonyms);
            con.commit();
        }
        catch (Exception e) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception e1) {
                throw new ThesaurusException("Vocabulary synonyms update failed", e1);
            }
            throw new ThesaurusException("Vocabulary synonyms update failed", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void deleteSynonyms(Connection con, long idVoca, long idTree, long idTerm) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca).and(TREE_ID, (Object)idTree).and(TERM_ID, (Object)idTerm);
            daoS.removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_SYNONYMS_DELETION_FAILED, e);
        }
    }

    public void deleteSynonymsAxis(Connection con, long idTree) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)idTree);
            daoS.removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Vocabulary synonyms axis deletion failed", e);
        }
    }

    public void deleteSynonymsTerms(Connection con, long idTree, List<String> idTerms) throws ThesaurusException {
        try {
            for (String id : idTerms) {
                long idTerm = Long.parseLong(id);
                this.deleteSynonymsTerm(con, idTree, idTerm);
            }
        }
        catch (ThesaurusException e) {
            throw new ThesaurusException("Vocabulary synonyms terms deletion failed", (Throwable)((Object)e));
        }
    }

    private void deleteSynonymsTerm(Connection con, long idTree, long idTerm) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)idTree).and(TERM_ID, (Object)idTerm);
            daoS.removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Vocabulary synonyms term deletion failed", e);
        }
    }

    public Collection<Jargon> getJargons(long idVoca) throws ThesaurusException {
        try {
            return this.getJargonDao().findBy(BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca));
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(CANNOT_GET_VOCABULARY_JARGON, e);
        }
    }

    public Collection<Jargon> getJargons(Collection<String> idUsers, int type) throws ThesaurusException {
        ArrayList<Jargon> jargons = new ArrayList<Jargon>();
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            for (String idUser : idUsers) {
                BeanCriteria criteria = BeanCriteria.addCriterion((String)ID_USER, (Object)idUser).and("type", (Object)type);
                Collection theJargons = daoJ.findBy(criteria);
                jargons.addAll(theJargons);
            }
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(CANNOT_GET_VOCABULARY_JARGON, e);
        }
        return jargons;
    }

    public Collection<Jargon> getJargons(Connection con, Collection<String> idUsers, int type) throws ThesaurusException {
        ArrayList<Jargon> jargons = new ArrayList<Jargon>();
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            for (String idUser : idUsers) {
                Collection theJargons = daoJ.findBy(con, BeanCriteria.addCriterion((String)ID_USER, (Object)idUser).and("type", (Object)type));
                jargons.addAll(theJargons);
            }
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(CANNOT_GET_VOCABULARY_JARGON, e);
        }
        return jargons;
    }

    public void createJargons(Collection<Jargon> jargons) throws ThesaurusException {
        try {
            for (Jargon jargon : jargons) {
                long idVoca = jargon.getIdVoca();
                String idUser = jargon.getIdUser();
                int type = jargon.getType();
                ArrayList<String> user = new ArrayList<String>();
                user.add(idUser);
                ArrayList<Jargon> actualJargon = new ArrayList<Jargon>(this.getJargons(user, type));
                if (!actualJargon.isEmpty()) {
                    Jargon theActualJargon = (Jargon)((Object)actualJargon.get(0));
                    if (theActualJargon.getIdVoca() == idVoca) continue;
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(((IdPK)theActualJargon.getPK()).getIdAsLong());
                    jargon.setPK((WAPrimaryKey)pk);
                    this.updateJargon(jargon);
                    continue;
                }
                this.createJargon(jargon);
            }
        }
        catch (ThesaurusException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, (Throwable)((Object)e));
        }
    }

    public void createJargons(Connection con, Collection<Jargon> jargons) throws ThesaurusException {
        try {
            for (Jargon jargon : jargons) {
                long idVoca = jargon.getIdVoca();
                String idUser = jargon.getIdUser();
                int type = jargon.getType();
                ArrayList<String> user = new ArrayList<String>();
                user.add(idUser);
                ArrayList<Jargon> actualJargon = new ArrayList<Jargon>(this.getJargons(con, user, type));
                if (!actualJargon.isEmpty()) {
                    Jargon theActualJargon = (Jargon)((Object)actualJargon.get(0));
                    if (theActualJargon.getIdVoca() == idVoca) continue;
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(((IdPK)theActualJargon.getPK()).getIdAsLong());
                    jargon.setPK((WAPrimaryKey)pk);
                    this.updateJargon(jargon);
                    continue;
                }
                this.createJargon(con, jargon);
            }
        }
        catch (ThesaurusException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, (Throwable)((Object)e));
        }
    }

    public void createVocaJargons(Collection<Jargon> jargons, long idVoca) throws ThesaurusException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
            this.deleteVocaJargons(con, idVoca);
            this.createJargons(con, jargons);
            con.commit();
        }
        catch (Exception e) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception e1) {
                throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, e1);
            }
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void createJargon(Jargon jargon) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            daoJ.add((SilverpeasEntityBean)jargon);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, e);
        }
    }

    private void updateJargon(Jargon jargon) throws ThesaurusException {
        try {
            long newIdVoca = jargon.getIdVoca();
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            IdPK pk = new IdPK();
            pk.setId(jargon.getPK().getId());
            Jargon jargonToModify = (Jargon)daoJ.findByPrimaryKey((WAPrimaryKey)pk);
            jargonToModify.setIdVoca(newIdVoca);
            daoJ.update((SilverpeasEntityBean)jargonToModify);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, e);
        }
    }

    private void createJargon(Connection con, Jargon jargon) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            daoJ.add(con, (SilverpeasEntityBean)jargon);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(VOCABULARY_JARGON_CREATION_FAILED, e);
        }
    }

    public Jargon getJargon(String idUser) throws ThesaurusException {
        Jargon jargon = null;
        try {
            SilverpeasBeanDAO<Jargon> daoJ = this.getJargonDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)ID_USER, (Object)idUser).and("type", (Object)0);
            Collection jargons = daoJ.findBy(criteria);
            Iterator i = jargons.iterator();
            if (i.hasNext()) {
                jargon = (Jargon)((Object)i.next());
            }
        }
        catch (PersistenceException e) {
            throw new ThesaurusException(CANNOT_GET_VOCABULARY_JARGON, e);
        }
        return jargon;
    }

    public Collection<Synonym> getSynonyms(long idVoca, String name) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            String nameEncode = this.encode(name);
            String nameNoAccent = FileServerUtils.replaceAccentChars((String)nameEncode);
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca).and(BeanCriteria.emptyCriteria().andWithFunction("LOWER(name)", (Object)nameEncode, "LOWER").orWithFunction("LOWER(name)", (Object)nameNoAccent, "LOWER"));
            return daoS.findBy(criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabulary synonyms", e);
        }
    }

    public Collection<Synonym> getSynonymsByTree(long idVoca, long idTree) throws ThesaurusException {
        try {
            SilverpeasBeanDAO<Synonym> daoS = this.getSynonymDao();
            BeanCriteria criteria = BeanCriteria.addCriterion((String)VOCA_ID, (Object)idVoca).and(TREE_ID, (Object)idTree);
            return daoS.findBy(criteria);
        }
        catch (PersistenceException e) {
            throw new ThesaurusException("Cannot get vocabulary synonyms by tree", e);
        }
    }
}

