/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.thesaurus.model;

import java.util.Objects;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.pdc.thesaurus.model.Vocabulary;
import org.silverpeas.core.pdc.thesaurus.service.ThesaurusService;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.kernel.annotation.NonNull;

public class Jargon
extends SilverpeasBean {
    private static final long serialVersionUID = 2926231339303196258L;
    private int type;
    private long idVoca;
    private String idUser;
    private final transient ThesaurusService thesaurus = ThesaurusService.getInstance();

    public String readUserName() {
        Object userName = null;
        if (this.type == 0) {
            UserDetail userDetail = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(this.getIdUser());
            if (userDetail != null) {
                userName = userDetail.getLastName() + " " + userDetail.getFirstName();
            }
        } else {
            Group group = OrganizationControllerProvider.getOrganisationController().getGroup(this.getIdUser());
            if (group != null) {
                userName = group.getName();
            }
        }
        return userName;
    }

    public String readVocaName() throws ThesaurusException {
        String name = "";
        if (this.idVoca != 0L) {
            Vocabulary voca = this.thesaurus.getVocabulary(this.idVoca);
            name = voca.getName();
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Jargon other = (Jargon)((Object)obj);
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.idUser, other.idUser);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.type;
        hash = 67 * hash + (this.idUser != null ? this.idUser.hashCode() : 0);
        return hash;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getIdVoca() {
        return this.idVoca;
    }

    public void setIdVoca(long idVoca) {
        this.idVoca = idVoca;
    }

    public String getIdUser() {
        return this.idUser;
    }

    public void setIdUser(String idUser) {
        this.idUser = idUser;
    }

    @NonNull
    protected String getTableName() {
        return "SB_Thesaurus_Jargon";
    }
}

