/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Repository
public class PdcUtilizationDAO {
    private static final String PDC_UTILIZATION_TABLE = "SB_Pdc_Utilization";
    private static final String TREE_TABLE = "SB_Tree_Tree";

    protected PdcUtilizationDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UsedAxis> getUsedAxisByInstanceId(Connection con, String instanceId) throws SQLException {
        String selectStatement = "select U.id, U.instanceId, U.axisId, U.baseValue, U.mandatory, U.variant, A.Name, A.AxisType, A.RootId, T.name from SB_Pdc_Utilization U, SB_Pdc_Axis A, SB_Tree_Tree T where U.axisId = A.id and A.RootId = T.treeId and U.baseValue = T.id and U.instanceId = ? order by A.AxisType Asc, A.AxisOrder ASC";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<UsedAxis> usedAxis = new ArrayList<UsedAxis>();
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, instanceId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                instanceId = rs.getString(2);
                int axisId = rs.getInt(3);
                int baseValue = rs.getInt(4);
                int mandatory = rs.getInt(5);
                int variant = rs.getInt(6);
                String axisName = rs.getString(7);
                String axisType = rs.getString(8);
                int axisRootId = rs.getInt(9);
                String valueName = rs.getString(10);
                UsedAxis axis = new UsedAxis(id, instanceId, axisId, baseValue, mandatory, variant);
                axis._setAxisName(axisName);
                axis._setAxisType(axisType);
                axis._setBaseValueName(valueName);
                axis._setAxisRootId(axisRootId);
                usedAxis.add(axis);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return usedAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBaseValue(Connection con, int oldBaseValue, int newBaseValue, int axisId, String treeId, String instanceId) throws SQLException {
        String updateQuery = " update SB_Pdc_Utilization set baseValue = ? where instanceId = ? and axisId = ? and baseValue = ? ";
        PreparedStatement prepStmt = null;
        int nbAffectedRows = 0;
        try {
            prepStmt = con.prepareStatement(updateQuery);
            prepStmt.setInt(1, newBaseValue);
            prepStmt.setString(2, instanceId);
            prepStmt.setInt(3, axisId);
            prepStmt.setInt(4, oldBaseValue);
            nbAffectedRows = prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return nbAffectedRows;
    }

    public boolean canUpdateBaseValue(Connection con, int baseValue, String axisId, String treeId, String instanceId) throws SQLException {
        boolean canUpdate = true;
        String motherPath = "";
        Object valuePath = "";
        String findSiblingValues = "select path from SB_Tree_Tree where treeId = ? and id = ?";
        try (PreparedStatement stmt = con.prepareStatement("select path from SB_Tree_Tree where treeId = ? and id = ?");){
            stmt.setInt(1, Integer.valueOf(treeId));
            stmt.setInt(2, baseValue);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    motherPath = rs.getString(1);
                }
                valuePath = motherPath + baseValue + "/";
            }
        }
        String findBaseValues = "select baseValue from SB_Pdc_Utilization where instanceId = ? and axisId = ? and baseValue in (select id from  SB_Tree_Tree where treeId = ? and path like ? and path not like ? and id <> ?) and baseValue <> ?";
        try (PreparedStatement stmt = con.prepareStatement("select baseValue from SB_Pdc_Utilization where instanceId = ? and axisId = ? and baseValue in (select id from  SB_Tree_Tree where treeId = ? and path like ? and path not like ? and id <> ?) and baseValue <> ?");){
            stmt.setString(1, instanceId);
            stmt.setInt(2, Integer.valueOf(axisId));
            stmt.setInt(3, Integer.valueOf(treeId));
            stmt.setString(4, motherPath + "%");
            stmt.setString(5, (String)valuePath + "%");
            stmt.setInt(6, baseValue);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    canUpdate = false;
                }
            }
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlreadyAdded(Connection con, String instanceId, int usedAxisId, int axisId, int baseValue, String treeId) throws SQLException {
        boolean isAdded;
        block5: {
            ArrayList<String> forbiddenValues = new ArrayList<String>();
            isAdded = false;
            List<Integer> allBaseValues = this.getAllBaseValues(con, usedAxisId, instanceId, axisId);
            isAdded = allBaseValues.contains(baseValue);
            if (allBaseValues.isEmpty() || isAdded) break block5;
            StringBuilder whereClause = new StringBuilder(" where treeId = " + treeId + " and (1=0 ");
            for (Integer value : allBaseValues) {
                whereClause.append(" or id = ").append(value.toString());
            }
            String selectQuery = " select path, id from SB_Tree_Tree " + whereClause.toString() + ")";
            whereClause = new StringBuilder("where treeId = " + treeId + " and (1=0 ");
            StringBuilder allCompletPathes = new StringBuilder();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery(selectQuery);
                while (rs.next()) {
                    String path = rs.getString(1);
                    String node = Integer.toString(rs.getInt(2));
                    allCompletPathes.append(path);
                    whereClause.append(" or path like '").append(path).append(node).append("/%'");
                }
                whereClause.append(")");
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)stmt);
            StringTokenizer st = new StringTokenizer(allCompletPathes.toString(), "/");
            String forbiddenValue = "";
            while (st.hasMoreTokens()) {
                forbiddenValue = st.nextToken();
                forbiddenValues.add(forbiddenValue);
            }
            this.setAllForbiddenValues(con, forbiddenValues, whereClause.toString());
            isAdded = forbiddenValues.contains(Integer.toString(baseValue));
        }
        return isAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllUsedAxis(Connection con, UsedAxis usedAxis) throws SQLException {
        String updateQuery = " update SB_Pdc_Utilization set mandatory = ?, variant = ? where instanceId = ? and axisId = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateQuery);
            prepStmt.setInt(1, usedAxis.getMandatory());
            prepStmt.setInt(2, usedAxis.getVariant());
            prepStmt.setString(3, usedAxis.getInstanceId());
            prepStmt.setInt(4, usedAxis.getAxisId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public void deleteAllAxisUsedByInstanceId(Connection con, String instanceId) throws SQLException {
        String sqlDeletion = "DELETE FROM SB_Pdc_Utilization WHERE instanceId = ?";
        try (PreparedStatement deletion = con.prepareStatement("DELETE FROM SB_Pdc_Utilization WHERE instanceId = ?");){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getAllBaseValues(Connection con, int usedAxisId, String instanceId, int axisId) throws SQLException {
        String selectQuery = "select baseValue from SB_Pdc_Utilization where instanceId = ? and axisId = ? and id <> ? ";
        ArrayList<Integer> allBaseValues = new ArrayList<Integer>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectQuery);
            prepStmt.setString(1, instanceId);
            prepStmt.setInt(2, axisId);
            prepStmt.setInt(3, usedAxisId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int baseValue = rs.getInt(1);
                allBaseValues.add(baseValue);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return allBaseValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllForbiddenValues(Connection con, List<String> forbiddenValues, String whereClause) throws SQLException {
        String selectQuery = "select id from SB_Tree_Tree " + whereClause;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectQuery);
            while (rs.next()) {
                forbiddenValues.add(Integer.toString(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
    }
}

