/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.form.displayers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.kernel.util.StringUtil;

public class PdcPositionsFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    private PdcManager pdcManager = null;

    public String[] getManagedTypes() {
        String[] s = new String[]{"text"};
        return s;
    }

    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
    }

    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext context) throws FormException {
        String language = context.getLanguage();
        Map parameters = template.getParameters(language);
        String axisId = (String)parameters.get("axisId");
        if (!StringUtil.isDefined((String)axisId) || !StringUtil.isInteger((String)axisId)) {
            out.println("??axisId??");
        } else {
            try {
                ContentManagementEngine contentMgtEngine = this.getContentManager();
                int silverContentId = contentMgtEngine.getSilverContentId(context.getObjectId(), context.getComponentId());
                List<ClassifyPosition> positions = this.getPdcManager().getPositions(silverContentId, context.getComponentId());
                ElementContainer result = new ElementContainer();
                Table positionsTables = new Table();
                positionsTables.setClass("pdcPositionsField");
                for (ClassifyPosition position : positions) {
                    String valueId = position.getValueOnAxis(Integer.parseInt(axisId));
                    if (!StringUtil.isDefined((String)valueId)) continue;
                    valueId = valueId.substring(0, valueId.length() - 1);
                    valueId = valueId.substring(valueId.lastIndexOf(47) + 1, valueId.length());
                    TR row = new TR();
                    TD cell = new TD();
                    Value value = this.getPdcManager().getValue(axisId, valueId);
                    cell.addElement(value.getName(language));
                    row.addElement((Element)cell);
                    positionsTables.addElement((Element)row);
                }
                result.addElement((Element)positionsTables);
                out.println(positionsTables.toString());
            }
            catch (ContentManagerException | PdcException object) {
                // empty catch block
            }
        }
    }

    private ContentManagementEngine getContentManager() throws ContentManagerException {
        return ContentManagementEngineProvider.getContentManagementEngine();
    }

    public List<String> update(List<FileItem> items, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        return new ArrayList<String>();
    }

    public List<String> update(String values, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        return new ArrayList<String>();
    }

    public boolean isDisplayedMandatory() {
        return false;
    }

    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    private PdcManager getPdcManager() {
        if (this.pdcManager == null) {
            this.pdcManager = PdcManager.get();
        }
        return this.pdcManager;
    }
}

