/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model;

import java.util.Set;
import org.silverpeas.components.mailinglist.service.model.beans.Attachment;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;

public class MessageIndexer {
    public static void indexMessage(Message message) {
        if (message.isModerated()) {
            MessageIndexer.unindexMessage(message);
            FullIndexEntry index = new FullIndexEntry(new IndexEntryKey(message.getComponentId(), "message", message.getId()));
            index.setTitle(message.getTitle());
            index.setCreationDate(message.getSentDate());
            index.setPreview(message.getSummary());
            index.addTextContent(message.getTitle());
            index.addTextContent(message.getSender());
            index.addTextContent(message.getBody());
            Set<Attachment> attachments = message.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                for (Attachment attachment : attachments) {
                    index.addFileContent(attachment.getPath(), "UTF-8", attachment.getContentType(), "fr");
                }
            }
            IndexEngineProxy.addIndexEntry((FullIndexEntry)index);
        }
    }

    public static void unindexMessage(Message message) {
        IndexEntryKey indexEntry = new IndexEntryKey(message.getComponentId(), "message", message.getId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    private MessageIndexer() {
    }
}

