/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final char[] emap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] dmap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private static final byte[][] lowerBoundMask = new byte[][]{{0, 0}, {30, 0}, {15, 32}, {7, 48}, {2, 56}, {1, 60}};
    private static final byte continuationMask = -64;
    private static final byte continuationResult = -128;

    private Base64() {
    }

    public static final String encode(String inputString) {
        try {
            return Base64.encode(inputString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("US-ASCII String encoding not supported by JVM");
        }
    }

    public static final String encode(byte[] inputBytes) {
        boolean onePadding = false;
        boolean twoPaddings = false;
        int len = inputBytes.length;
        if (len == 0) {
            return new String("");
        }
        int ntb = len % 3 == 0 ? len / 3 : len / 3 + 1;
        if (len % 3 == 1) {
            twoPaddings = true;
        } else if (len % 3 == 2) {
            onePadding = true;
        }
        char[] encodedChars = new char[ntb * 4];
        int i = 0;
        int j = 0;
        int k = 1;
        while (i < len) {
            int t = 0xFF & inputBytes[i];
            encodedChars[j] = emap[t >> 2];
            if (k == ntb && twoPaddings) {
                encodedChars[j + 1] = emap[(t & 3) << 4];
                encodedChars[j + 2] = 61;
                encodedChars[j + 3] = 61;
                break;
            }
            int t1 = 0xFF & inputBytes[i + 1];
            encodedChars[j + 1] = emap[((t & 3) << 4) + ((t1 & 0xF0) >> 4)];
            if (k == ntb && onePadding) {
                encodedChars[j + 2] = emap[(t1 & 0xF) << 2];
                encodedChars[j + 3] = 61;
                break;
            }
            int t2 = 0xFF & inputBytes[i + 2];
            encodedChars[j + 2] = emap[(t1 & 0xF) << 2 | (t2 & 0xC0) >> 6];
            encodedChars[j + 3] = emap[t2 & 0x3F];
            i += 3;
            j += 4;
            ++k;
        }
        return new String(encodedChars);
    }

    public static final byte[] decode(String encodedString) {
        char[] c = new char[encodedString.length()];
        encodedString.getChars(0, encodedString.length(), c, 0);
        return Base64.decode(c);
    }

    public static final byte[] decode(char[] encodedChars) {
        byte[] decodedBytes;
        int dByteLen;
        int ecLen = encodedChars.length;
        int gn = ecLen / 4;
        boolean onePad = false;
        boolean twoPads = false;
        if (encodedChars.length == 0) {
            return new byte[0];
        }
        if (ecLen % 4 != 0) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.Base64Decoder: decode: mal-formatted encode value");
        }
        if (encodedChars[ecLen - 1] == '=' && encodedChars[ecLen - 2] == '=') {
            twoPads = true;
            dByteLen = gn * 3 - 2;
            decodedBytes = new byte[dByteLen];
        } else if (encodedChars[ecLen - 1] == '=') {
            onePad = true;
            dByteLen = gn * 3 - 1;
            decodedBytes = new byte[dByteLen];
        } else {
            dByteLen = gn * 3;
            decodedBytes = new byte[dByteLen];
        }
        int i = 0;
        int j = 0;
        int k = 1;
        while (i < ecLen) {
            decodedBytes[j] = (byte)(dmap[encodedChars[i]] << 2 | (dmap[encodedChars[i + 1]] & 0x30) >> 4);
            if (k == gn && twoPads) break;
            decodedBytes[j + 1] = (byte)((dmap[encodedChars[i + 1]] & 0xF) << 4 | (dmap[encodedChars[i + 2]] & 0x3C) >> 2);
            if (k == gn && onePad) break;
            decodedBytes[j + 2] = (byte)((dmap[encodedChars[i + 2]] & 3) << 6 | dmap[encodedChars[i + 3]] & 0x3F);
            i += 4;
            j += 3;
            ++k;
        }
        return decodedBytes;
    }

    public static final byte[] decode(StringBuffer encodedSBuf, int start, int end) {
        byte[] decodedBytes;
        int dByteLen;
        int esbLen = end - start;
        int gn = esbLen / 4;
        boolean onePad = false;
        boolean twoPads = false;
        if (encodedSBuf.length() == 0) {
            return new byte[0];
        }
        if (esbLen % 4 != 0) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.Base64Decoder: decode error: mal-formatted encode value");
        }
        if (encodedSBuf.charAt(end - 1) == '=' && encodedSBuf.charAt(end - 2) == '=') {
            twoPads = true;
            dByteLen = gn * 3 - 2;
            decodedBytes = new byte[dByteLen];
        } else if (encodedSBuf.charAt(end - 1) == '=') {
            onePad = true;
            dByteLen = gn * 3 - 1;
            decodedBytes = new byte[dByteLen];
        } else {
            dByteLen = gn * 3;
            decodedBytes = new byte[dByteLen];
        }
        int i = 0;
        int j = 0;
        int k = 1;
        while (i < esbLen) {
            decodedBytes[j] = (byte)(dmap[encodedSBuf.charAt(start + i)] << 2 | (dmap[encodedSBuf.charAt(start + i + 1)] & 0x30) >> 4);
            if (k == gn && twoPads) break;
            decodedBytes[j + 1] = (byte)((dmap[encodedSBuf.charAt(start + i + 1)] & 0xF) << 4 | (dmap[encodedSBuf.charAt(start + i + 2)] & 0x3C) >> 2);
            if (k == gn && onePad) break;
            decodedBytes[j + 2] = (byte)((dmap[encodedSBuf.charAt(start + i + 2)] & 3) << 6 | dmap[encodedSBuf.charAt(start + i + 3)] & 0x3F);
            i += 4;
            j += 3;
            ++k;
        }
        return decodedBytes;
    }

    public static final boolean isLDIFSafe(byte[] bytes) {
        int len = bytes.length;
        if (len > 0) {
            byte testChar = bytes[0];
            if (testChar == 0 || testChar == 10 || testChar == 13 || testChar == 32 || testChar == 58 || testChar == 60 || testChar < 0) {
                return false;
            }
            if (bytes[len - 1] == 32) {
                return false;
            }
            if (len > 1) {
                for (int i = 1; i < bytes.length; ++i) {
                    testChar = bytes[i];
                    if (testChar != 0 && testChar != 10 && testChar != 13 && testChar >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static final boolean isLDIFSafe(String str) {
        try {
            return Base64.isLDIFSafe(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("UTF-8 String encoding not supported by JVM");
        }
    }

    private static int getByteCount(byte b) {
        if (b > 0) {
            return 0;
        }
        if ((b & 0xE0) == 192) {
            return 1;
        }
        if ((b & 0xF0) == 224) {
            return 2;
        }
        if ((b & 0xF8) == 240) {
            return 3;
        }
        if ((b & 0xFC) == 248) {
            return 4;
        }
        if ((b & 0xFF) == 252) {
            return 5;
        }
        return -1;
    }

    public static boolean isValidUTF8(byte[] array, boolean isUCS2Only) {
        int index = 0;
        while (index < array.length) {
            int count = Base64.getByteCount(array[index]);
            if (count == 0) {
                ++index;
                continue;
            }
            if (count == -1 || index + count >= array.length || isUCS2Only && count >= 3) {
                return false;
            }
            if ((lowerBoundMask[count][0] & array[index]) == 0 && (lowerBoundMask[count][1] & array[index + 1]) == 0) {
                return false;
            }
            for (int i = 1; i <= count; ++i) {
                if ((array[index + i] & 0xFFFFFFC0) == -128) continue;
                return false;
            }
            index += count + 1;
        }
        return true;
    }
}

