/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchResults;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspml.message.Identifier;
import org.openspml.message.SearchResult;

public class SPMLSearchResults
extends LDAPSearchResults {
    LDAPControl[] controls;
    int msgRespPtr;
    List results;
    SearchResult lastread;
    boolean empty;
    boolean wasRead;
    Iterator iter;

    public SPMLSearchResults(List results) {
        this.results = results;
        this.iter = results.iterator();
        this.empty = false;
        this.wasRead = true;
    }

    public SPMLSearchResults() {
        this.empty = true;
        this.wasRead = true;
    }

    void abandon() {
    }

    public int getCount() {
        return 0;
    }

    public LDAPControl[] getResponseControls() {
        return this.controls;
    }

    public boolean hasMore() {
        return this.iter.hasNext();
    }

    public LDAPEntry next() throws LDAPException {
        SearchResult res = (SearchResult)this.iter.next();
        Map attribs = res.getAttributeMap();
        Iterator it = attribs.keySet().iterator();
        LDAPAttributeSet attribSet = new LDAPAttributeSet();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object o = attribs.get(name);
            if (o instanceof String) {
                String attrib = (String)attribs.get(name);
                LDAPAttribute ldapAttrib = new LDAPAttribute(name);
                if (attrib == null) {
                    attrib = "";
                }
                ldapAttrib.addValue(attrib);
                attribSet.add(ldapAttrib);
                continue;
            }
            if (!(o instanceof List)) continue;
            List l = (List)attribs.get(name);
            Iterator vals = l.iterator();
            LDAPAttribute ldapAttrib = new LDAPAttribute(name);
            while (vals.hasNext()) {
                String attrib = (String)vals.next();
                if (attrib == null) {
                    attrib = "";
                }
                ldapAttrib.addValue(attrib);
            }
            attribSet.add(ldapAttrib);
        }
        Identifier id = res.getIdentifier();
        LDAPAttribute ldapAttrib = new LDAPAttribute(id.getType().substring(id.getType().lastIndexOf(35) + 1));
        ldapAttrib.addValue(id.getId());
        attribSet.add(ldapAttrib);
        LDAPEntry ret = new LDAPEntry(id.getType().substring(id.getType().lastIndexOf(35) + 1) + "=" + id.getId(), attribSet);
        return ret;
    }
}

