/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.EnumeratedIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class LDAPSchemaElement
extends LDAPAttribute
implements Serializable {
    protected String[] names = new String[]{""};
    protected String oid = "";
    protected String description = "";
    protected boolean obsolete = false;
    protected String[] qualifier = new String[]{""};
    protected HashMap hashQualifier = new HashMap();

    protected LDAPSchemaElement(String attrName) {
        super(attrName);
    }

    public String[] getNames() {
        if (this.names == null) {
            return null;
        }
        return (String[])this.names.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.oid;
    }

    public String[] getQualifier(String name) {
        AttributeQualifier attr = (AttributeQualifier)this.hashQualifier.get(name);
        if (attr != null) {
            return attr.getValues();
        }
        return null;
    }

    public Enumeration getQualifierNames() {
        return new EnumeratedIterator(this.hashQualifier.keySet().iterator());
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public String toString() {
        return this.formatString();
    }

    protected abstract String formatString();

    public void setQualifier(String name, String[] values) {
        AttributeQualifier attrQualifier = new AttributeQualifier(name, values);
        this.hashQualifier.put(name, attrQualifier);
        super.setValue(this.formatString());
    }

    public void addValue(String value) {
        throw new UnsupportedOperationException("addValue is not supported by LDAPSchemaElement");
    }

    public void addValue(Byte[] value) {
        throw new UnsupportedOperationException("addValue is not supported by LDAPSchemaElement");
    }

    public void removeValue(String value) {
        throw new UnsupportedOperationException("removeValue is not supported by LDAPSchemaElement");
    }

    public void removeValue(Byte[] value) {
        throw new UnsupportedOperationException("removeValue is not supported by LDAPSchemaElement");
    }

    private void writeObject(ObjectOutputStream objectOStrm) throws IOException {
        objectOStrm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectIStrm) throws IOException, ClassNotFoundException {
        objectIStrm.defaultReadObject();
    }
}

