/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.File;
import java.io.FileInputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.lib.Clean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Seed {
    private static String getDevRandomFilename() {
        String filename = "/dev/urandom";
        if (System.getProperty("java.security.egd") != null) {
            filename = System.getProperty("java.security.egd");
        }
        return filename;
    }

    public static SecureRandom getSecureRandom(byte[] seed) throws CryptoException {
        SecureRandom sr = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
            if (seed != null && !seed.equals("")) {
                sr.setSeed(seed);
                Clean.blank(seed);
            } else if (new File(Seed.getDevRandomFilename()).exists()) {
                byte[] salt = new byte[8192];
                new FileInputStream(Seed.getDevRandomFilename()).read(salt);
                sr.setSeed(salt);
                Clean.blank(salt);
                salt = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException(e.getMessage());
        }
        return sr;
    }
}

