/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.sharing.model.NodeAccessControl;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.ShareableAccessControl;
import org.silverpeas.core.sharing.security.ShareableNode;
import org.silverpeas.core.sharing.security.ShareableResource;

@Entity
@DiscriminatorValue(value="Node")
public class NodeTicket
extends Ticket {
    private static final long serialVersionUID = 8560572170859334369L;

    public NodeTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Node";
    }

    protected NodeTicket() {
        this.sharedObjectType = "Node";
    }

    @Override
    @Transient
    public ShareableAccessControl getAccessControl() {
        return new NodeAccessControl(this);
    }

    @Transient
    public ShareableResource<NodeDetail> getResource() {
        NodeService nodeService = NodeService.get();
        NodeDetail node = nodeService.getDetail(new NodePK(String.valueOf(this.getSharedObjectId()), this.getComponentId()));
        if (node != null) {
            return new ShareableNode(this.getToken(), node);
        }
        return null;
    }
}

