/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.Collection;
import java.util.Collections;
import org.owasp.encoder.Encode;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.notification.AbstractFormsOnlineRequestUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;

public class FormsOnlineValidationRequestUserNotification
extends AbstractFormsOnlineRequestUserNotification {
    public FormsOnlineValidationRequestUserNotification(FormInstance resource, NotifAction action) {
        super(resource, action);
    }

    protected String getBundleSubjectKey() {
        if (NotifAction.VALIDATE.equals((Object)this.getAction())) {
            return "formsOnline.msgFormValidated";
        }
        return "formsOnline.msgFormRefused";
    }

    protected String getTitle(String language) {
        int nbValidationSteps;
        Object title = super.getTitle(language);
        if ((NotifAction.REFUSE.equals((Object)this.getAction()) || NotifAction.VALIDATE.equals((Object)this.getAction()) || NotifAction.PENDING_VALIDATION.equals((Object)this.getAction())) && (nbValidationSteps = this.getNbValidationSteps()) > 1) {
            int step = this.getCurrentValidationStep();
            title = (String)title + " " + this.getBundle(language).getStringWithParams("formsOnline.msgFormValidated.steps", new Object[]{Integer.toString(step), Integer.toString(nbValidationSteps)});
        }
        return title;
    }

    protected String getTemplateFileName() {
        if (NotifAction.VALIDATE.equals((Object)this.getAction())) {
            return "notificationValidated";
        }
        return "notificationDenied";
    }

    @Override
    protected void performTemplateData(String language, FormInstance resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        ((FormInstance)this.getResource()).getValidations().getLatestValidation().ifPresent(v -> template.setAttribute("comment", (Object)Encode.forHtml((String)v.getComment())));
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(((FormInstance)this.getResource()).getCreatorId());
    }

    protected int getNbValidationSteps() {
        return ((FormInstance)this.getResource()).getValidationsSchema().size();
    }

    protected int getCurrentValidationStep() {
        return Math.min(((FormInstance)this.getResource()).getValidations().size(), this.getNbValidationSteps());
    }
}

