/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;

public class BasedFileSystem
implements FileSystem {
    protected final FileSystem fsBase;
    protected final String basePath;

    public BasedFileSystem(FileSystem fsBase, String relRootPath) {
        if (fsBase == null) {
            throw new IllegalArgumentException("invalid file system argument");
        }
        this.fsBase = fsBase;
        if (relRootPath == null) {
            throw new IllegalArgumentException("invalid null path argument");
        }
        if (((String)relRootPath).equals("/")) {
            throw new IllegalArgumentException("invalid path argument");
        }
        if (!((String)relRootPath).startsWith("/")) {
            relRootPath = "/" + (String)relRootPath;
        }
        if (((String)relRootPath).endsWith("/")) {
            relRootPath = ((String)relRootPath).substring(0, ((String)relRootPath).length() - 1);
        }
        this.basePath = relRootPath;
    }

    protected String buildBasePath(String path) {
        if (path.startsWith("/")) {
            if (path.length() == 1) {
                return this.basePath;
            }
            return this.basePath + path;
        }
        return this.basePath + "/" + path;
    }

    @Override
    public void init() throws FileSystemException {
        if (!this.fsBase.isFolder(this.basePath)) {
            this.fsBase.createFolder(this.basePath);
        }
    }

    @Override
    public void close() throws FileSystemException {
    }

    @Override
    public void createFolder(String folderPath) throws FileSystemException {
        this.fsBase.createFolder(this.buildBasePath(folderPath));
    }

    @Override
    public void deleteFile(String filePath) throws FileSystemException {
        this.fsBase.deleteFile(this.buildBasePath(filePath));
    }

    @Override
    public void deleteFolder(String folderPath) throws FileSystemException {
        this.fsBase.deleteFolder(this.buildBasePath(folderPath));
    }

    @Override
    public boolean exists(String path) throws FileSystemException {
        return this.fsBase.exists(this.buildBasePath(path));
    }

    @Override
    public InputStream getInputStream(String filePath) throws FileSystemException {
        return this.fsBase.getInputStream(this.buildBasePath(filePath));
    }

    @Override
    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        return this.fsBase.getOutputStream(this.buildBasePath(filePath));
    }

    @Override
    public boolean hasChildren(String path) throws FileSystemException {
        return this.fsBase.hasChildren(this.buildBasePath(path));
    }

    @Override
    public boolean isFile(String path) throws FileSystemException {
        return this.fsBase.isFile(this.buildBasePath(path));
    }

    @Override
    public boolean isFolder(String path) throws FileSystemException {
        return this.fsBase.isFolder(this.buildBasePath(path));
    }

    @Override
    public long lastModified(String path) throws FileSystemException {
        return this.fsBase.lastModified(this.buildBasePath(path));
    }

    @Override
    public long length(String filePath) throws FileSystemException {
        return this.fsBase.length(this.buildBasePath(filePath));
    }

    @Override
    public String[] list(String folderPath) throws FileSystemException {
        return this.fsBase.list(this.buildBasePath(folderPath));
    }

    @Override
    public String[] listFiles(String folderPath) throws FileSystemException {
        return this.fsBase.listFiles(this.buildBasePath(folderPath));
    }

    @Override
    public String[] listFolders(String folderPath) throws FileSystemException {
        return this.fsBase.listFolders(this.buildBasePath(folderPath));
    }
}

