/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;

public class PRTokeniser {
    private final StringBuilder outBuf = new StringBuilder();
    public static final boolean[] delims = new boolean[]{true, true, false, false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, false, true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final String EMPTY = "";
    private final RandomAccessFileOrArray file;
    protected TokenType type;
    protected String stringValue;
    protected int reference;
    protected int generation;
    protected boolean hexString;

    public PRTokeniser(RandomAccessFileOrArray file) {
        this.file = file;
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public void close() throws IOException {
        this.file.close();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public RandomAccessFileOrArray getSafeFile() {
        return new RandomAccessFileOrArray(this.file);
    }

    public RandomAccessFileOrArray getFile() {
        return this.file;
    }

    public String readString(int size) throws IOException {
        int ch;
        StringBuilder buf = new StringBuilder();
        while (size-- > 0 && (ch = this.read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    public static final boolean isWhitespace(int ch) {
        return PRTokeniser.isWhitespace(ch, true);
    }

    public static final boolean isWhitespace(int ch, boolean isWhitespace) {
        return isWhitespace && ch == 0 || ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32;
    }

    public static final boolean isDelimiter(int ch) {
        return ch == 40 || ch == 41 || ch == 60 || ch == 62 || ch == 91 || ch == 93 || ch == 47 || ch == 37;
    }

    public static final boolean isDelimiterWhitespace(int ch) {
        return delims[ch + 1];
    }

    public TokenType getTokenType() {
        return this.type;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public int getReference() {
        return this.reference;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void backOnePosition(int ch) {
        if (ch != -1) {
            this.file.pushBack((byte)ch);
        }
    }

    public void throwError(String error) throws IOException {
        throw new InvalidPdfException(MessageLocalization.getComposedMessage("1.at.file.pointer.2", error, String.valueOf(this.file.getFilePointer())));
    }

    public int getHeaderOffset() throws IOException {
        String str = this.readString(1024);
        int idx = str.indexOf("%PDF-");
        if (idx < 0 && (idx = str.indexOf("%FDF-")) < 0) {
            throw new InvalidPdfException(MessageLocalization.getComposedMessage("pdf.header.not.found", new Object[0]));
        }
        return idx;
    }

    public char checkPdfHeader() throws IOException {
        this.file.seek(0L);
        String str = this.readString(1024);
        int idx = str.indexOf("%PDF-");
        if (idx != 0) {
            throw new InvalidPdfException(MessageLocalization.getComposedMessage("pdf.header.not.found", new Object[0]));
        }
        return str.charAt(7);
    }

    public void checkFdfHeader() throws IOException {
        this.file.seek(0L);
        String str = this.readString(1024);
        int idx = str.indexOf("%FDF-");
        if (idx != 0) {
            throw new InvalidPdfException(MessageLocalization.getComposedMessage("fdf.header.not.found", new Object[0]));
        }
    }

    public long getStartxref() throws IOException {
        int arrLength = 1024;
        long fileLength = this.file.length();
        long pos = fileLength - (long)arrLength;
        if (pos < 1L) {
            pos = 1L;
        }
        while (pos > 0L) {
            this.file.seek(pos);
            String str = this.readString(arrLength);
            int idx = str.lastIndexOf("startxref");
            if (idx >= 0) {
                return pos + (long)idx;
            }
            pos = pos - (long)arrLength + 9L;
        }
        throw new InvalidPdfException(MessageLocalization.getComposedMessage("pdf.startxref.not.found", new Object[0]));
    }

    public static int getHex(int v) {
        if (v >= 48 && v <= 57) {
            return v - 48;
        }
        if (v >= 65 && v <= 70) {
            return v - 65 + 10;
        }
        if (v >= 97 && v <= 102) {
            return v - 97 + 10;
        }
        return -1;
    }

    public void nextValidToken() throws IOException {
        int level = 0;
        String n1 = null;
        String n2 = null;
        long ptr = 0L;
        block6: while (this.nextToken()) {
            if (this.type == TokenType.COMMENT) continue;
            switch (level) {
                case 0: {
                    if (this.type != TokenType.NUMBER) {
                        return;
                    }
                    ptr = this.file.getFilePointer();
                    n1 = this.stringValue;
                    ++level;
                    continue block6;
                }
                case 1: {
                    if (this.type != TokenType.NUMBER) {
                        this.file.seek(ptr);
                        this.type = TokenType.NUMBER;
                        this.stringValue = n1;
                        return;
                    }
                    n2 = this.stringValue;
                    ++level;
                    continue block6;
                }
            }
            if (this.type != TokenType.OTHER || !this.stringValue.equals("R")) {
                this.file.seek(ptr);
                this.type = TokenType.NUMBER;
                this.stringValue = n1;
                return;
            }
            this.type = TokenType.REF;
            try {
                this.reference = Integer.parseInt(n1);
                this.generation = Integer.parseInt(n2);
            }
            catch (NumberFormatException ex) {
                this.reference = -1;
                this.generation = 0;
            }
            return;
        }
        if (level == 1) {
            this.type = TokenType.NUMBER;
        }
    }

    public boolean nextToken() throws IOException {
        int ch = 0;
        while ((ch = this.file.read()) != -1 && PRTokeniser.isWhitespace(ch)) {
        }
        if (ch == -1) {
            this.type = TokenType.ENDOFFILE;
            return false;
        }
        this.outBuf.setLength(0);
        this.stringValue = EMPTY;
        switch (ch) {
            case 91: {
                this.type = TokenType.START_ARRAY;
                break;
            }
            case 93: {
                this.type = TokenType.END_ARRAY;
                break;
            }
            case 47: {
                this.outBuf.setLength(0);
                this.type = TokenType.NAME;
                while (!delims[(ch = this.file.read()) + 1]) {
                    if (ch == 35) {
                        ch = (PRTokeniser.getHex(this.file.read()) << 4) + PRTokeniser.getHex(this.file.read());
                    }
                    this.outBuf.append((char)ch);
                }
                this.backOnePosition(ch);
                break;
            }
            case 62: {
                ch = this.file.read();
                if (ch != 62) {
                    this.throwError(MessageLocalization.getComposedMessage("greaterthan.not.expected", new Object[0]));
                }
                this.type = TokenType.END_DIC;
                break;
            }
            case 60: {
                int v1 = this.file.read();
                if (v1 == 60) {
                    this.type = TokenType.START_DIC;
                    break;
                }
                this.outBuf.setLength(0);
                this.type = TokenType.STRING;
                this.hexString = true;
                int v2 = 0;
                while (true) {
                    if (PRTokeniser.isWhitespace(v1)) {
                        v1 = this.file.read();
                        continue;
                    }
                    if (v1 == 62 || (v1 = PRTokeniser.getHex(v1)) < 0) break;
                    v2 = this.file.read();
                    while (PRTokeniser.isWhitespace(v2)) {
                        v2 = this.file.read();
                    }
                    if (v2 == 62) {
                        ch = v1 << 4;
                        this.outBuf.append((char)ch);
                        break;
                    }
                    if ((v2 = PRTokeniser.getHex(v2)) < 0) break;
                    ch = (v1 << 4) + v2;
                    this.outBuf.append((char)ch);
                    v1 = this.file.read();
                }
                if (v1 >= 0 && v2 >= 0) break;
                this.throwError(MessageLocalization.getComposedMessage("error.reading.string", new Object[0]));
                break;
            }
            case 37: {
                this.type = TokenType.COMMENT;
                while ((ch = this.file.read()) != -1 && ch != 13 && ch != 10) {
                }
                break;
            }
            case 40: {
                this.outBuf.setLength(0);
                this.type = TokenType.STRING;
                this.hexString = false;
                int nesting = 0;
                while ((ch = this.file.read()) != -1) {
                    if (ch == 40) {
                        ++nesting;
                    } else if (ch == 41) {
                        --nesting;
                    } else if (ch == 92) {
                        boolean lineBreak = false;
                        ch = this.file.read();
                        switch (ch) {
                            case 110: {
                                ch = 10;
                                break;
                            }
                            case 114: {
                                ch = 13;
                                break;
                            }
                            case 116: {
                                ch = 9;
                                break;
                            }
                            case 98: {
                                ch = 8;
                                break;
                            }
                            case 102: {
                                ch = 12;
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 92: {
                                break;
                            }
                            case 13: {
                                lineBreak = true;
                                ch = this.file.read();
                                if (ch == 10) break;
                                this.backOnePosition(ch);
                                break;
                            }
                            case 10: {
                                lineBreak = true;
                                break;
                            }
                            default: {
                                if (ch < 48 || ch > 55) break;
                                int octal = ch - 48;
                                ch = this.file.read();
                                if (ch < 48 || ch > 55) {
                                    this.backOnePosition(ch);
                                    ch = octal;
                                    break;
                                }
                                octal = (octal << 3) + ch - 48;
                                ch = this.file.read();
                                if (ch < 48 || ch > 55) {
                                    this.backOnePosition(ch);
                                    ch = octal;
                                    break;
                                }
                                octal = (octal << 3) + ch - 48;
                                ch = octal & 0xFF;
                                break;
                            }
                        }
                        if (lineBreak) continue;
                        if (ch < 0) {
                            break;
                        }
                    } else if (ch == 13) {
                        ch = this.file.read();
                        if (ch < 0) break;
                        if (ch != 10) {
                            this.backOnePosition(ch);
                            ch = 10;
                        }
                    }
                    if (nesting == -1) break;
                    this.outBuf.append((char)ch);
                }
                if (ch != -1) break;
                this.throwError(MessageLocalization.getComposedMessage("error.reading.string", new Object[0]));
                break;
            }
            default: {
                this.outBuf.setLength(0);
                if (ch == 45 || ch == 43 || ch == 46 || ch >= 48 && ch <= 57) {
                    this.type = TokenType.NUMBER;
                    boolean isReal = false;
                    int numberOfMinuses = 0;
                    if (ch == 45) {
                        do {
                            ++numberOfMinuses;
                        } while ((ch = this.file.read()) == 45);
                        this.outBuf.append('-');
                    } else {
                        this.outBuf.append((char)ch);
                        ch = this.file.read();
                    }
                    while (ch != -1 && (ch >= 48 && ch <= 57 || ch == 46)) {
                        if (ch == 46) {
                            isReal = true;
                        }
                        this.outBuf.append((char)ch);
                        ch = this.file.read();
                    }
                    if (numberOfMinuses > 1 && !isReal) {
                        this.outBuf.setLength(0);
                        this.outBuf.append('0');
                    }
                } else {
                    this.type = TokenType.OTHER;
                    do {
                        this.outBuf.append((char)ch);
                    } while (!delims[(ch = this.file.read()) + 1]);
                }
                if (ch == -1) break;
                this.backOnePosition(ch);
            }
        }
        if (this.outBuf != null) {
            this.stringValue = this.outBuf.toString();
        }
        return true;
    }

    public long longValue() {
        return Long.parseLong(this.stringValue);
    }

    public int intValue() {
        return Integer.parseInt(this.stringValue);
    }

    public boolean readLineSegment(byte[] input) throws IOException {
        return this.readLineSegment(input, true);
    }

    public boolean readLineSegment(byte[] input, boolean isNullWhitespace) throws IOException {
        long cur;
        int c = -1;
        boolean eol = false;
        int ptr = 0;
        int len = input.length;
        if (ptr < len) {
            while (PRTokeniser.isWhitespace(c = this.read(), isNullWhitespace)) {
            }
        }
        while (!eol && ptr < len) {
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    cur = this.getFilePointer();
                    if (this.read() == 10) break;
                    this.seek(cur);
                    break;
                }
                default: {
                    input[ptr++] = (byte)c;
                }
            }
            if (eol || len <= ptr) break;
            c = this.read();
        }
        if (ptr >= len) {
            eol = false;
            while (!eol) {
                c = this.read();
                switch (c) {
                    case -1: 
                    case 10: {
                        eol = true;
                        break;
                    }
                    case 13: {
                        eol = true;
                        cur = this.getFilePointer();
                        if (this.read() == 10) break;
                        this.seek(cur);
                    }
                }
            }
        }
        if (c == -1 && ptr == 0) {
            return false;
        }
        if (ptr + 2 <= len) {
            input[ptr++] = 32;
            input[ptr] = 88;
        }
        return true;
    }

    public static long[] checkObjectStart(byte[] line) {
        try {
            PRTokeniser tk = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(line)));
            int num = 0;
            int gen = 0;
            if (!tk.nextToken() || tk.getTokenType() != TokenType.NUMBER) {
                return null;
            }
            num = tk.intValue();
            if (!tk.nextToken() || tk.getTokenType() != TokenType.NUMBER) {
                return null;
            }
            gen = tk.intValue();
            if (!tk.nextToken()) {
                return null;
            }
            if (!tk.getStringValue().equals("obj")) {
                return null;
            }
            return new long[]{num, gen};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isHexString() {
        return this.hexString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        NUMBER,
        STRING,
        NAME,
        COMMENT,
        START_ARRAY,
        END_ARRAY,
        START_DIC,
        END_DIC,
        REF,
        OTHER,
        ENDOFFILE;

    }
}

