/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum(value=String.class)
public enum ErrorMessageType {
    INVALID_FILTER("invalidFilter", "The specified filter syntax was invalid, or the specified attribute and filter comparison combination is not supported."),
    TOO_MANY("tooMany", "The specified filter yields many more results than the server is willing to calculate or process.  For example, a filter such as \"(userName pr)\" by itself would return all entries with a \"userName\" and MAY not be acceptable to the service provider."),
    UNIQUENESS("uniqueness", "One or more of the attribute values are already in use or are reserved."),
    MUTABILITY("mutability", "The attempted modification is not compatible with the target attribute's mutability or current state (e.g., modification of an \"immutable\" attribute with an existing value)."),
    INVALID_SYNTAX("invalidSyntax", "The request body message structure was invalid or did not conform to the request schema."),
    INVALID_PATH("invalidPath", "The \"path\" attribute was invalid or malformed (see invalid or malformed (see Figure 7)."),
    NO_TARGET("noTarget", "The specified \"path\" did not yield an attribute or attribute value that could be operated on.  This occurs when the specified \"path\" value contains a filter that yields no match."),
    INVALID_VALUE("invalidValue", "A required value was missing, or the value specified was not compatible with the operation or attribute type (see Section 2.2 of [RFC7643]), or resource schema (see Section 4 of [RFC7643])."),
    INVALID_VERS("invalidVers", "The specified SCIM protocol version is not supported (see Section 3.13)."),
    SENSITIVE("sensitive", "The specified request cannot be completed, due to the passing of sensitive (e.g., personal) information in a request URI.  For example, personal information SHALL NOT be transmitted over request URIs.  See Section 7.5.2.");

    private String scimType;
    private String detail;

    private ErrorMessageType(String scimType, String detail) {
        this.scimType = scimType;
        this.detail = detail;
    }

    public String getScimType() {
        return this.scimType;
    }

    public String getDetail() {
        return this.detail;
    }
}

