/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.jackrabbit.oak.segment.standby.jmx.ObservablePartnerMBean;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationPartnerMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationObserver {
    private static final int DEFAULT_MAX_CLIENT_MBEANS = 10;
    private static final Logger log = LoggerFactory.getLogger(CommunicationObserver.class);
    private final Map<String, CommunicationPartnerMBean> beans = new HashMap<String, CommunicationPartnerMBean>();
    private final int maxClientMBeans;
    private final String id;

    private static ObjectName getMBeanName(CommunicationPartnerMBean bean) throws MalformedObjectNameException {
        return new ObjectName("org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"Client " + bean.getName() + "\"");
    }

    private static String oldest(Map<String, CommunicationPartnerMBean> beans) {
        CommunicationPartnerMBean oldest = null;
        for (CommunicationPartnerMBean bean : beans.values()) {
            if (oldest != null && !oldest.getLastSeen().after(bean.getLastSeen())) continue;
            oldest = bean;
        }
        if (oldest == null) {
            throw new IllegalArgumentException("no clients available");
        }
        return oldest.getName();
    }

    public CommunicationObserver(String id) {
        this(id, 10);
    }

    CommunicationObserver(String id, int maxClientMBeans) {
        this.id = id;
        this.maxClientMBeans = maxClientMBeans;
    }

    void registerCommunicationPartner(CommunicationPartnerMBean m) throws Exception {
        ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(m, ObservablePartnerMBean.class), CommunicationObserver.getMBeanName(m));
    }

    private void safeRegisterCommunicationPartner(CommunicationPartnerMBean m) {
        try {
            this.registerCommunicationPartner(m);
        }
        catch (Exception e) {
            log.error(String.format("Unable to register MBean for client %s", m.getName()), (Throwable)e);
        }
    }

    void unregisterCommunicationPartner(CommunicationPartnerMBean m) throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(CommunicationObserver.getMBeanName(m));
    }

    private void safeUnregisterCommunicationPartner(CommunicationPartnerMBean m) {
        try {
            this.unregisterCommunicationPartner(m);
        }
        catch (Exception e) {
            log.error(String.format("Unable to unregister MBean for client %s", m.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ArrayList<CommunicationPartnerMBean> unregister;
        Map<String, CommunicationPartnerMBean> map = this.beans;
        synchronized (map) {
            unregister = new ArrayList<CommunicationPartnerMBean>(this.beans.values());
            this.beans.clear();
        }
        for (CommunicationPartnerMBean bean : unregister) {
            this.safeUnregisterCommunicationPartner(bean);
        }
    }

    public void gotMessageFrom(String client, String request, String address, int port) throws MalformedObjectNameException {
        log.debug("Message '{}' received from client {}", (Object)request, (Object)client);
        this.createOrUpdateClientMBean(client, address, port, m -> m.onMessageReceived(new Date(), request));
    }

    public void didSendSegmentBytes(String client, int size) {
        log.debug("Segment with size {} sent to client {}", (Object)size, (Object)client);
        this.updateClientMBean(client, m -> m.onSegmentSent(size));
    }

    public void didSendBinariesBytes(String client, long size) {
        log.debug("Binary with size {} sent to client {}", (Object)size, (Object)client);
        this.updateClientMBean(client, m -> m.onBinarySent(size));
    }

    public String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdateClientMBean(String clientName, String remoteAddress, int remotePort, Consumer<CommunicationPartnerMBean> update) throws MalformedObjectNameException {
        CommunicationPartnerMBean bean;
        ArrayList<CommunicationPartnerMBean> unregister = null;
        boolean register = false;
        Map<String, CommunicationPartnerMBean> map = this.beans;
        synchronized (map) {
            bean = this.beans.get(clientName);
            if (bean == null) {
                bean = new CommunicationPartnerMBean(clientName, remoteAddress, remotePort);
                while (this.beans.size() >= this.maxClientMBeans) {
                    if (unregister == null) {
                        unregister = new ArrayList<CommunicationPartnerMBean>();
                    }
                    unregister.add(this.beans.remove(CommunicationObserver.oldest(this.beans)));
                }
                this.beans.put(clientName, bean);
                register = true;
            }
        }
        update.accept(bean);
        if (register) {
            this.safeRegisterCommunicationPartner(bean);
        }
        if (unregister != null) {
            for (CommunicationPartnerMBean c : unregister) {
                this.safeUnregisterCommunicationPartner(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientMBean(String id, Consumer<CommunicationPartnerMBean> update) {
        CommunicationPartnerMBean c;
        Map<String, CommunicationPartnerMBean> map = this.beans;
        synchronized (map) {
            c = this.beans.get(id);
        }
        if (c == null) {
            throw new IllegalStateException("no client found with id " + id);
        }
        update.accept(c);
    }
}

