/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.phonenumber;

import edu.psu.swe.scim.spec.phonenumber.PhoneNumberParser;
import edu.psu.swe.scim.spec.phonenumber.PhoneNumberParserBaseListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePrintingListener
extends PhoneNumberParserBaseListener {
    private static final Logger log = LoggerFactory.getLogger(TreePrintingListener.class);
    private int indent = -1;

    @Override
    public void enterPhoneNumber(PhoneNumberParser.PhoneNumberContext ctx) {
        log.info(this.indent("--- Enter PhoneNumber -->"));
    }

    @Override
    public void exitPhoneNumber(PhoneNumberParser.PhoneNumberContext ctx) {
        log.info(this.indent("<-- Exit PhoneNumber ---"));
    }

    @Override
    public void enterGlobalNumber(PhoneNumberParser.GlobalNumberContext ctx) {
        log.info(this.indent("<-- Enter GlobalNumber ---"));
    }

    @Override
    public void exitGlobalNumber(PhoneNumberParser.GlobalNumberContext ctx) {
        log.info(this.indent("<-- Exit GlobalNumber ---"));
    }

    @Override
    public void enterLocalNumber(PhoneNumberParser.LocalNumberContext ctx) {
        log.info(this.indent("<-- Enter LocalNumber ---"));
    }

    @Override
    public void exitLocalNumber(PhoneNumberParser.LocalNumberContext ctx) {
        log.info(this.indent("<-- Exit LocalNumber ---"));
    }

    @Override
    public void enterPhoneContext(PhoneNumberParser.PhoneContextContext ctx) {
        log.info(this.indent("<-- Enter PhoneContext "));
    }

    @Override
    public void exitPhoneContext(PhoneNumberParser.PhoneContextContext ctx) {
        log.info(this.indent("<-- Exit PhoneContext"));
    }

    @Override
    public void enterParameter(PhoneNumberParser.ParameterContext ctx) {
        log.info(this.indent("<-- Enter Parameter"));
    }

    @Override
    public void exitParameter(PhoneNumberParser.ParameterContext ctx) {
        log.info(this.indent("<-- Exit Parameter"));
    }

    @Override
    public void enterLocalNumberDigits(PhoneNumberParser.LocalNumberDigitsContext ctx) {
        log.info(this.indent("<-- Enter LocalNumberDigits"));
    }

    @Override
    public void exitLocalNumberDigits(PhoneNumberParser.LocalNumberDigitsContext ctx) {
        log.info(this.indent("<-- Exit LocalNumberDigits"));
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        ++this.indent;
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        --this.indent;
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        String text = node.getText();
        if (StringUtils.isNotEmpty((CharSequence)text.trim())) {
            log.info(this.indent(text));
        }
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        log.error(this.indent(node.getText()));
    }

    private String indent(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            sb.append("    ");
        }
        sb.append(s);
        return sb.toString();
    }
}

