/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.net.URI;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HttpRequestDecorator
extends HttpRequestWrapper {
    private HttpHeaders httpHeaders;
    private boolean existingHeadersAdded;
    MultiValueMap<String, String> parameters = new LinkedMultiValueMap();

    public HttpRequestDecorator(HttpRequest request) {
        super(request);
    }

    public void addParameter(String name, String value) {
        this.parameters.add((Object)name, (Object)value);
    }

    public HttpHeaders getHeaders() {
        if (!this.existingHeadersAdded) {
            this.httpHeaders = new HttpHeaders();
            this.httpHeaders.putAll((Map)this.getRequest().getHeaders());
            this.existingHeadersAdded = true;
        }
        return this.httpHeaders;
    }

    public URI getURI() {
        if (this.parameters.isEmpty()) {
            return super.getURI();
        }
        return URIBuilder.fromUri(super.getURI()).queryParams(this.parameters).build();
    }
}

