/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.support;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormMapHttpMessageConverter
implements HttpMessageConverter<Map<String, String>> {
    private final FormHttpMessageConverter delegate = new FormHttpMessageConverter();

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (supportedMediaType.equals((Object)MediaType.MULTIPART_FORM_DATA) || !supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null || MediaType.ALL.equals((Object)mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.delegate.getSupportedMediaTypes();
    }

    public Map<String, String> read(Class<? extends Map<String, String>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        LinkedMultiValueMap lmvm = new LinkedMultiValueMap();
        Class<?> mvmClazz = lmvm.getClass();
        MultiValueMap mvm = this.delegate.read(mvmClazz, inputMessage);
        return mvm.toSingleValueMap();
    }

    public void write(Map<String, String> t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        LinkedMultiValueMap mvm = new LinkedMultiValueMap();
        mvm.setAll(t);
        this.delegate.write((MultiValueMap)mvm, contentType, outputMessage);
    }
}

