/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.support.HttpRequestDecorator;

class OAuth2TokenParameterRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String parameterName;
    private final String accessToken;

    public OAuth2TokenParameterRequestInterceptor(String accessToken) {
        this(accessToken, "access_token");
    }

    public OAuth2TokenParameterRequestInterceptor(String accessToken, String parameterName) {
        this.accessToken = accessToken;
        this.parameterName = parameterName;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request);
        protectedResourceRequest.addParameter(this.parameterName, this.accessToken);
        return execution.execute((HttpRequest)protectedResourceRequest, body);
    }
}

