/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.oauth2.TokenStrategy;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuth2ApiBinding
implements ApiBinding {
    private final String accessToken;
    private final RestTemplate restTemplate;

    protected AbstractOAuth2ApiBinding() {
        this.accessToken = null;
        this.restTemplate = this.createRestTemplateWithCulledMessageConverters();
        this.configureRestTemplate(this.restTemplate);
    }

    protected AbstractOAuth2ApiBinding(String accessToken) {
        this(accessToken, TokenStrategy.AUTHORIZATION_HEADER);
    }

    protected AbstractOAuth2ApiBinding(String accessToken, TokenStrategy tokenStrategy) {
        this.accessToken = accessToken;
        this.restTemplate = this.createRestTemplate(accessToken, this.getOAuth2Version(), tokenStrategy);
        this.configureRestTemplate(this.restTemplate);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public boolean isAuthorized() {
        return this.accessToken != null;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getFormMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getJsonMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getByteArrayMessageConverter());
        return messageConverters;
    }

    protected FormHttpMessageConverter getFormMessageConverter() {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        converter.setCharset(Charset.forName("UTF-8"));
        ArrayList<Object> partConverters = new ArrayList<Object>();
        partConverters.add(new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        partConverters.add(stringHttpMessageConverter);
        partConverters.add(new ResourceHttpMessageConverter());
        converter.setPartConverters(partConverters);
        return converter;
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }

    protected ByteArrayHttpMessageConverter getByteArrayMessageConverter() {
        ByteArrayHttpMessageConverter converter = new ByteArrayHttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.IMAGE_JPEG, MediaType.IMAGE_GIF, MediaType.IMAGE_PNG));
        return converter;
    }

    private RestTemplate createRestTemplate(String accessToken, OAuth2Version version, TokenStrategy tokenStrategy) {
        RestTemplate client = this.createRestTemplateWithCulledMessageConverters();
        ClientHttpRequestInterceptor interceptor = tokenStrategy.interceptor(accessToken, version);
        LinkedList<ClientHttpRequestInterceptor> interceptors = new LinkedList<ClientHttpRequestInterceptor>();
        interceptors.add(interceptor);
        client.setInterceptors(interceptors);
        return client;
    }

    private RestTemplate createRestTemplateWithCulledMessageConverters() {
        RestTemplate client;
        List<HttpMessageConverter<?>> messageConverters = this.getMessageConverters();
        try {
            client = new RestTemplate(messageConverters);
        }
        catch (NoSuchMethodError e) {
            client = new RestTemplate();
            client.setMessageConverters(messageConverters);
        }
        client.setRequestFactory(ClientHttpRequestFactorySelector.getRequestFactory());
        return client;
    }
}

