/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.mem;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.NoSuchConnectionException;
import org.springframework.social.connect.NotConnectedException;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InMemoryConnectionRepository
implements ConnectionRepository {
    private MultiValueMap<String, Connection<?>> connections;
    private ConnectionFactoryLocator connectionFactoryLocator;

    public InMemoryConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connections = new LinkedMultiValueMap();
    }

    @Override
    public MultiValueMap<String, Connection<?>> findAllConnections() {
        return this.connections;
    }

    @Override
    public List<Connection<?>> findConnections(String providerId) {
        List emptyConnectionList = Collections.emptyList();
        return this.connections.containsKey((Object)providerId) ? (List)this.connections.get((Object)providerId) : emptyConnectionList;
    }

    @Override
    public <A> List<Connection<A>> findConnections(Class<A> apiType) {
        List<Connection<A>> providerConnections = this.findConnections(this.getProviderId(apiType));
        return providerConnections;
    }

    @Override
    public MultiValueMap<String, Connection<?>> findConnectionsToUsers(MultiValueMap<String, String> providerUserIds) {
        Assert.notEmpty(providerUserIds);
        LinkedMultiValueMap connectionsToUsers = new LinkedMultiValueMap(providerUserIds.size());
        for (Map.Entry providerConnectionEntry : providerUserIds.entrySet()) {
            String providerId = (String)providerConnectionEntry.getKey();
            List userIds = (List)providerConnectionEntry.getValue();
            if (!this.connections.containsKey((Object)providerId)) continue;
            List providerConnections = (List)this.connections.get((Object)providerId);
            for (Connection connection : providerConnections) {
                if (!userIds.contains(connection.getKey().getProviderUserId())) continue;
                connectionsToUsers.add((Object)providerId, (Object)connection);
            }
        }
        return connectionsToUsers;
    }

    @Override
    public Connection<?> getConnection(ConnectionKey connectionKey) {
        if (this.connections.containsKey((Object)connectionKey.getProviderId())) {
            List providerConnections = (List)this.connections.get((Object)connectionKey.getProviderId());
            for (Connection connection : providerConnections) {
                if (!connection.getKey().equals(connectionKey)) continue;
                return connection;
            }
        }
        throw new NoSuchConnectionException(connectionKey);
    }

    @Override
    public <A> Connection<A> getConnection(Class<A> apiType, String providerUserId) {
        return this.getConnection(new ConnectionKey(this.getProviderId(apiType), providerUserId));
    }

    @Override
    public <A> Connection<A> getPrimaryConnection(Class<A> apiType) {
        Connection<A> primaryConnection = this.findPrimaryConnection(apiType);
        if (primaryConnection == null) {
            throw new NotConnectedException(this.getProviderId(apiType));
        }
        return primaryConnection;
    }

    @Override
    public <A> Connection<A> findPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        if (this.connections.containsKey((Object)providerId)) {
            return (Connection)((List)this.connections.get((Object)providerId)).get(0);
        }
        return null;
    }

    @Override
    public void addConnection(Connection<?> connection) {
        try {
            ConnectionKey connectionKey = connection.getKey();
            this.getConnection(connectionKey);
            throw new DuplicateConnectionException(connectionKey);
        }
        catch (NoSuchConnectionException e) {
            this.connections.add((Object)connection.createData().getProviderId(), connection);
            return;
        }
    }

    @Override
    public void updateConnection(Connection<?> connection) {
        this.connections.add((Object)connection.createData().getProviderId(), connection);
    }

    @Override
    public void removeConnections(String providerId) {
        this.connections.remove((Object)providerId);
    }

    @Override
    public void removeConnection(ConnectionKey connectionKey) {
        String providerId = connectionKey.getProviderId();
        if (this.connections.containsKey((Object)providerId)) {
            List providerConnections = (List)this.connections.get((Object)providerId);
            for (Connection connection : providerConnections) {
                if (!connection.getKey().equals(connectionKey)) continue;
                providerConnections.remove(connection);
            }
        }
    }

    private <A> String getProviderId(Class<A> apiType) {
        return this.connectionFactoryLocator.getConnectionFactory(apiType).getProviderId();
    }
}

