/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.question.service;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.model.Answer;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.answer.service.AnswerService;
import org.silverpeas.core.questioncontainer.question.dao.QuestionDAO;
import org.silverpeas.core.questioncontainer.question.model.Question;
import org.silverpeas.core.questioncontainer.question.model.QuestionPK;
import org.silverpeas.core.questioncontainer.question.model.QuestionRuntimeException;
import org.silverpeas.core.questioncontainer.question.service.QuestionService;
import org.silverpeas.core.questioncontainer.result.service.QuestionResultService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.REQUIRED)
public class DefaultQuestionService
implements QuestionService {
    private static final String QUESTION_EX_MSG = "question";
    @Inject
    private AnswerService currentAnswerService;
    @Inject
    private QuestionResultService currentQuestionResultService;

    protected DefaultQuestionService() {
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public Question getQuestion(QuestionPK questionPK) {
        Connection con = this.getConnection();
        try {
            Question question = QuestionDAO.getQuestion(con, questionPK);
            Collection<Answer> answers = this.getAnswersByQuestionPK(questionPK);
            question.setAnswers(answers);
            Question question2 = question;
            return question2;
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)QUESTION_EX_MSG, (Object)questionPK.toString()), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private Collection<Answer> getAnswersByQuestionPK(QuestionPK questionPK) {
        return this.currentAnswerService.getAnswersByQuestionPK(new ResourceReference((WAPrimaryKey)questionPK));
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public Collection<Question> getQuestionsByFatherPK(QuestionPK questionPK, String fatherId) {
        Connection con = this.getConnection();
        try {
            Collection<Question> questions = QuestionDAO.getQuestionsByFatherPK(con, questionPK, fatherId);
            ArrayList<Question> result = new ArrayList<Question>();
            for (Question question : questions) {
                Collection<Answer> answers = this.getAnswersByQuestionPK(question.getPK());
                question.setAnswers(answers);
                result.add(question);
            }
            ArrayList<Question> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)QUESTION_EX_MSG, (Object)questionPK), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public QuestionPK createQuestion(Question question) {
        Connection con = this.getConnection();
        try {
            QuestionPK questionPK = QuestionDAO.createQuestion(con, question);
            this.currentAnswerService.addAnswersToAQuestion(question.getAnswers(), new ResourceReference((WAPrimaryKey)questionPK));
            QuestionPK questionPK2 = questionPK;
            return questionPK2;
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnAdding((String)"question on father", (Object)question.getFatherId()), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void createQuestions(Collection<Question> questions, String fatherId) {
        int displayOrder = 1;
        for (Question question : questions) {
            question.setFatherId(fatherId);
            question.setDisplayOrder(displayOrder);
            this.createQuestion(question);
            ++displayOrder;
        }
    }

    @Override
    public void deleteQuestionsByFatherPK(QuestionPK questionPK, String fatherId) {
        Connection con = this.getConnection();
        AnswerService answerService = this.currentAnswerService;
        QuestionResultService questionResultService = this.currentQuestionResultService;
        try {
            Collection<Question> questions = this.getQuestionsByFatherPK(questionPK, fatherId);
            for (Question question : questions) {
                QuestionPK questionPKToDelete = question.getPK();
                questionResultService.deleteQuestionResultsToQuestion(new ResourceReference((WAPrimaryKey)questionPKToDelete));
                answerService.deleteAnswersToAQuestion(new ResourceReference((WAPrimaryKey)questionPKToDelete));
            }
            QuestionDAO.deleteQuestionsByFatherPK(con, questionPK, fatherId);
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)QUESTION_EX_MSG, (Object)questionPK), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteQuestion(QuestionPK questionPK) {
        Connection con = this.getConnection();
        try {
            this.currentQuestionResultService.deleteQuestionResultsToQuestion(new ResourceReference((WAPrimaryKey)questionPK));
            this.deleteAnswersToAQuestion(questionPK);
            QuestionDAO.deleteQuestion(con, questionPK);
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnDeleting((String)QUESTION_EX_MSG, (Object)questionPK), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void updateQuestion(Question questionDetail) {
        this.updateQuestionHeader(questionDetail);
        this.updateAnswersToAQuestion(questionDetail);
    }

    @Override
    public void updateQuestionHeader(Question questionDetail) {
        Connection con = this.getConnection();
        try {
            QuestionDAO.updateQuestion(con, questionDetail);
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(SilverpeasExceptionMessages.failureOnUpdate((String)QUESTION_EX_MSG, (Object)questionDetail.getPK()), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void updateAnswersToAQuestion(Question questionDetail) {
        this.deleteAnswersToAQuestion(questionDetail.getPK());
        this.createAnswersToAQuestion(questionDetail);
    }

    @Override
    public void updateAnswerToAQuestion(Answer answerDetail) {
        this.currentAnswerService.updateAnswerToAQuestion(answerDetail.getQuestionPK(), answerDetail);
    }

    @Override
    public void deleteAnswersToAQuestion(QuestionPK questionPK) {
        Collection<Answer> answers = this.getAnswersByQuestionPK(questionPK);
        for (Answer answer : answers) {
            AnswerPK answerPKToDelete = answer.getPK();
            this.deleteAnswerToAQuestion(answerPKToDelete, questionPK);
        }
    }

    @Override
    public void deleteAnswerToAQuestion(AnswerPK answerPK, QuestionPK questionPK) {
        this.currentAnswerService.deleteAnswerToAQuestion(new ResourceReference((WAPrimaryKey)questionPK), answerPK.getId());
    }

    @Override
    public void createAnswersToAQuestion(Question questionDetail) {
        Collection<Answer> answers = questionDetail.getAnswers();
        for (Answer answer : answers) {
            this.createAnswerToAQuestion(answer, questionDetail.getPK());
        }
    }

    @Override
    public AnswerPK createAnswerToAQuestion(Answer answerDetail, QuestionPK questionPK) {
        this.currentAnswerService.addAnswerToAQuestion(answerDetail, new ResourceReference((WAPrimaryKey)questionPK));
        return null;
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new QuestionRuntimeException(e);
        }
    }
}

